/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class DataColumn
implements Serializable {
    private String columnName = null;
    private DataColumnTypeEnum dataColumnType = null;

    public DataColumn columnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The localized value of the column name as provided by the client")
    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public DataColumn dataColumnType(DataColumnTypeEnum dataColumnType) {
        this.dataColumnType = dataColumnType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of column being requested")
    @JsonProperty(value="dataColumnType")
    public DataColumnTypeEnum getDataColumnType() {
        return this.dataColumnType;
    }

    public void setDataColumnType(DataColumnTypeEnum dataColumnType) {
        this.dataColumnType = dataColumnType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataColumn dataColumn = (DataColumn)o;
        return Objects.equals(this.columnName, dataColumn.columnName) && Objects.equals((Object)this.dataColumnType, (Object)dataColumn.dataColumnType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.dataColumnType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataColumn {\n");
        sb.append("    columnName: ").append(this.toIndentedString(this.columnName)).append("\n");
        sb.append("    dataColumnType: ").append(this.toIndentedString((Object)this.dataColumnType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DataColumnTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INTERVAL_START("INTERVAL_START"),
        INTERVAL_END("INTERVAL_END"),
        INTERVAL_COMPLETE("INTERVAL_COMPLETE"),
        MEDIA_TYPE("MEDIA_TYPE"),
        QUEUE_ID("QUEUE_ID"),
        QUEUE_NAME("QUEUE_NAME"),
        OFFER("OFFER"),
        ANSWER("ANSWER"),
        ANSWER_PERCENT("ANSWER_PERCENT"),
        ABANDON("ABANDON"),
        ABANDON_PERCENT("ABANDON_PERCENT"),
        TIME_TO_ABANDON("TIME_TO_ABANDON"),
        ASA("ASA"),
        SERVICE_LEVEL_PERCENT("SERVICE_LEVEL_PERCENT"),
        SLA_LEVEL_PERCENT_TARGET("SLA_LEVEL_PERCENT_TARGET"),
        AVERAGE_HANDLE("AVERAGE_HANDLE"),
        TOTAL_HANDLE("TOTAL_HANDLE"),
        AVERAGE_TALK("AVERAGE_TALK"),
        TOTAL_TALK("TOTAL_TALK"),
        AVERAGE_HOLD("AVERAGE_HOLD"),
        TOTAL_HOLD("TOTAL_HOLD"),
        AVERAGE_ACW("AVERAGE_ACW"),
        TOTAL_ACW("TOTAL_ACW"),
        HOLD("HOLD"),
        TRANSFER("TRANSFER"),
        TRANSFER_PERCENT("TRANSFER_PERCENT"),
        FLOW_OUT("FLOW_OUT"),
        HANDLE("HANDLE"),
        AVERAGE_WAIT("AVERAGE_WAIT");

        private String value;

        private DataColumnTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DataColumnTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DataColumnTypeEnum value : DataColumnTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DataColumnTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

