/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.mypurecloud.sdk.v2.model.AnalyticsSession;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AnalyticsParticipant
implements Serializable {
    private String participantId = null;
    private String participantName = null;
    private String userId = null;
    private PurposeEnum purpose = null;
    private String externalContactId = null;
    private String externalOrganizationId = null;
    private FlaggedReasonEnum flaggedReason = null;
    private List<AnalyticsSession> sessions = new ArrayList<AnalyticsSession>();

    public AnalyticsParticipant participantId(String participantId) {
        this.participantId = participantId;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the participant")
    @JsonProperty(value="participantId")
    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public AnalyticsParticipant participantName(String participantName) {
        this.participantName = participantName;
        return this;
    }

    @ApiModelProperty(example="null", value="A human readable name identifying the participant")
    @JsonProperty(value="participantName")
    public String getParticipantName() {
        return this.participantName;
    }

    public void setParticipantName(String participantName) {
        this.participantName = participantName;
    }

    public AnalyticsParticipant userId(String userId) {
        this.userId = userId;
        return this;
    }

    @ApiModelProperty(example="null", value="If a user, then this will be the unique identifier for the user")
    @JsonProperty(value="userId")
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public AnalyticsParticipant purpose(PurposeEnum purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="The participant's purpose")
    @JsonProperty(value="purpose")
    public PurposeEnum getPurpose() {
        return this.purpose;
    }

    public void setPurpose(PurposeEnum purpose) {
        this.purpose = purpose;
    }

    public AnalyticsParticipant externalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
        return this;
    }

    @ApiModelProperty(example="null", value="External Contact Identifier")
    @JsonProperty(value="externalContactId")
    public String getExternalContactId() {
        return this.externalContactId;
    }

    public void setExternalContactId(String externalContactId) {
        this.externalContactId = externalContactId;
    }

    public AnalyticsParticipant externalOrganizationId(String externalOrganizationId) {
        this.externalOrganizationId = externalOrganizationId;
        return this;
    }

    @ApiModelProperty(example="null", value="External Organization Identifier")
    @JsonProperty(value="externalOrganizationId")
    public String getExternalOrganizationId() {
        return this.externalOrganizationId;
    }

    public void setExternalOrganizationId(String externalOrganizationId) {
        this.externalOrganizationId = externalOrganizationId;
    }

    public AnalyticsParticipant flaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
        return this;
    }

    @ApiModelProperty(example="null", value="Reason for which participant flagged conversation")
    @JsonProperty(value="flaggedReason")
    public FlaggedReasonEnum getFlaggedReason() {
        return this.flaggedReason;
    }

    public void setFlaggedReason(FlaggedReasonEnum flaggedReason) {
        this.flaggedReason = flaggedReason;
    }

    public AnalyticsParticipant sessions(List<AnalyticsSession> sessions) {
        this.sessions = sessions;
        return this;
    }

    @ApiModelProperty(example="null", value="List of sessions associated to this participant")
    @JsonProperty(value="sessions")
    public List<AnalyticsSession> getSessions() {
        return this.sessions;
    }

    public void setSessions(List<AnalyticsSession> sessions) {
        this.sessions = sessions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsParticipant analyticsParticipant = (AnalyticsParticipant)o;
        return Objects.equals(this.participantId, analyticsParticipant.participantId) && Objects.equals(this.participantName, analyticsParticipant.participantName) && Objects.equals(this.userId, analyticsParticipant.userId) && Objects.equals((Object)this.purpose, (Object)analyticsParticipant.purpose) && Objects.equals(this.externalContactId, analyticsParticipant.externalContactId) && Objects.equals(this.externalOrganizationId, analyticsParticipant.externalOrganizationId) && Objects.equals((Object)this.flaggedReason, (Object)analyticsParticipant.flaggedReason) && Objects.equals(this.sessions, analyticsParticipant.sessions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.participantId, this.participantName, this.userId, this.purpose, this.externalContactId, this.externalOrganizationId, this.flaggedReason, this.sessions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsParticipant {\n");
        sb.append("    participantId: ").append(this.toIndentedString(this.participantId)).append("\n");
        sb.append("    participantName: ").append(this.toIndentedString(this.participantName)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString((Object)this.purpose)).append("\n");
        sb.append("    externalContactId: ").append(this.toIndentedString(this.externalContactId)).append("\n");
        sb.append("    externalOrganizationId: ").append(this.toIndentedString(this.externalOrganizationId)).append("\n");
        sb.append("    flaggedReason: ").append(this.toIndentedString((Object)this.flaggedReason)).append("\n");
        sb.append("    sessions: ").append(this.toIndentedString(this.sessions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FlaggedReasonEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        GENERAL("general");

        private String value;

        private FlaggedReasonEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FlaggedReasonEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FlaggedReasonEnum value : FlaggedReasonEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FlaggedReasonEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static enum PurposeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MANUAL("manual"),
        DIALER("dialer"),
        INBOUND("inbound"),
        ACD("acd"),
        IVR("ivr"),
        VOICEMAIL("voicemail"),
        OUTBOUND("outbound"),
        AGENT("agent"),
        USER("user"),
        STATION("station"),
        GROUP("group"),
        CUSTOMER("customer"),
        EXTERNAL("external"),
        FAX("fax"),
        WORKFLOW("workflow");

        private String value;

        private PurposeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PurposeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PurposeEnum value : PurposeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PurposeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

