/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.MediaParticipantRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchConversationsEmailParticipantRequest {
    private String emailId;
    private String participantId;
    private MediaParticipantRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public PatchConversationsEmailParticipantRequest withEmailId(String emailId) {
        this.setEmailId(emailId);
        return this;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public PatchConversationsEmailParticipantRequest withParticipantId(String participantId) {
        this.setParticipantId(participantId);
        return this;
    }

    public MediaParticipantRequest getBody() {
        return this.body;
    }

    public void setBody(MediaParticipantRequest body) {
        this.body = body;
    }

    public PatchConversationsEmailParticipantRequest withBody(MediaParticipantRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchConversationsEmailParticipantRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<MediaParticipantRequest> withHttpInfo() {
        if (this.emailId == null) {
            throw new IllegalStateException("Missing the required parameter 'emailId' when building request for PatchConversationsEmailParticipantRequest.");
        }
        if (this.participantId == null) {
            throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsEmailParticipantRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsEmailParticipantRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/conversations/emails/{emailId}/participants/{participantId}").withPathParameter("emailId", this.emailId).withPathParameter("participantId", this.participantId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String emailId, String participantId, MediaParticipantRequest body) {
        return new Builder().withRequiredParams(emailId, participantId, body);
    }

    public static class Builder {
        private final PatchConversationsEmailParticipantRequest request = new PatchConversationsEmailParticipantRequest();

        private Builder() {
        }

        public Builder withEmailId(String emailId) {
            this.request.setEmailId(emailId);
            return this;
        }

        public Builder withParticipantId(String participantId) {
            this.request.setParticipantId(participantId);
            return this;
        }

        public Builder withBody(MediaParticipantRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String emailId, String participantId, MediaParticipantRequest body) {
            this.request.setEmailId(emailId);
            this.request.setParticipantId(participantId);
            this.request.setBody(body);
            return this;
        }

        public PatchConversationsEmailParticipantRequest build() {
            if (this.request.emailId == null) {
                throw new IllegalStateException("Missing the required parameter 'emailId' when building request for PatchConversationsEmailParticipantRequest.");
            }
            if (this.request.participantId == null) {
                throw new IllegalStateException("Missing the required parameter 'participantId' when building request for PatchConversationsEmailParticipantRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchConversationsEmailParticipantRequest.");
            }
            return this.request;
        }
    }
}

