/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetConversationsCallbackRequest {
    private String callbackId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCallbackId() {
        return this.callbackId;
    }

    public void setCallbackId(String callbackId) {
        this.callbackId = callbackId;
    }

    public GetConversationsCallbackRequest withCallbackId(String callbackId) {
        this.setCallbackId(callbackId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetConversationsCallbackRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.callbackId == null) {
            throw new IllegalStateException("Missing the required parameter 'callbackId' when building request for GetConversationsCallbackRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/conversations/callbacks/{callbackId}").withPathParameter("callbackId", this.callbackId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String callbackId) {
        return new Builder().withRequiredParams(callbackId);
    }

    public static class Builder {
        private final GetConversationsCallbackRequest request = new GetConversationsCallbackRequest();

        private Builder() {
        }

        public Builder withCallbackId(String callbackId) {
            this.request.setCallbackId(callbackId);
            return this;
        }

        public Builder withRequiredParams(String callbackId) {
            this.request.setCallbackId(callbackId);
            return this;
        }

        public GetConversationsCallbackRequest build() {
            if (this.request.callbackId == null) {
                throw new IllegalStateException("Missing the required parameter 'callbackId' when building request for GetConversationsCallbackRequest.");
            }
            return this.request;
        }
    }
}

