/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetOutboundContactlistRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String contactListId;
    private Boolean includeImportStatus;
    private Boolean includeSize;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getContactListId() {
        return this.contactListId;
    }

    public void setContactListId(String contactListId) {
        this.contactListId = contactListId;
    }

    public GetOutboundContactlistRequest withContactListId(String contactListId) {
        this.setContactListId(contactListId);
        return this;
    }

    public Boolean getIncludeImportStatus() {
        return this.includeImportStatus;
    }

    public void setIncludeImportStatus(Boolean includeImportStatus) {
        this.includeImportStatus = includeImportStatus;
    }

    public GetOutboundContactlistRequest withIncludeImportStatus(Boolean includeImportStatus) {
        this.setIncludeImportStatus(includeImportStatus);
        return this;
    }

    public Boolean getIncludeSize() {
        return this.includeSize;
    }

    public void setIncludeSize(Boolean includeSize) {
        this.includeSize = includeSize;
    }

    public GetOutboundContactlistRequest withIncludeSize(Boolean includeSize) {
        this.setIncludeSize(includeSize);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetOutboundContactlistRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.contactListId == null) {
            throw new IllegalStateException("Missing the required parameter 'contactListId' when building request for GetOutboundContactlistRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/outbound/contactlists/{contactListId}").withPathParameter("contactListId", this.contactListId).withQueryParameters("includeImportStatus", "", this.includeImportStatus).withQueryParameters("includeSize", "", this.includeSize).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String contactListId) {
        return new Builder().withRequiredParams(contactListId);
    }

    public static class Builder {
        private final GetOutboundContactlistRequest request = new GetOutboundContactlistRequest();

        private Builder() {
        }

        public Builder withContactListId(String contactListId) {
            this.request.setContactListId(contactListId);
            return this;
        }

        public Builder withIncludeImportStatus(Boolean includeImportStatus) {
            this.request.setIncludeImportStatus(includeImportStatus);
            return this;
        }

        public Builder withIncludeSize(Boolean includeSize) {
            this.request.setIncludeSize(includeSize);
            return this;
        }

        public Builder withRequiredParams(String contactListId) {
            this.request.setContactListId(contactListId);
            return this;
        }

        public GetOutboundContactlistRequest build() {
            return this.request;
        }
    }
}

