/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DeleteRoutingQueueUserRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String queueId;
    private String memberId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public DeleteRoutingQueueUserRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public DeleteRoutingQueueUserRequest withMemberId(String memberId) {
        this.setMemberId(memberId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteRoutingQueueUserRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for DeleteRoutingQueueUserRequest.");
        }
        if (this.memberId == null) {
            throw new IllegalStateException("Missing the required parameter 'memberId' when building request for DeleteRoutingQueueUserRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/routing/queues/{queueId}/users/{memberId}").withPathParameter("queueId", this.queueId).withPathParameter("memberId", this.memberId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId, String memberId) {
        return new Builder().withRequiredParams(queueId, memberId);
    }

    public static class Builder {
        private final DeleteRoutingQueueUserRequest request = new DeleteRoutingQueueUserRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withMemberId(String memberId) {
            this.request.setMemberId(memberId);
            return this;
        }

        public Builder withRequiredParams(String queueId, String memberId) {
            this.request.setQueueId(queueId);
            this.request.setMemberId(memberId);
            return this;
        }

        public DeleteRoutingQueueUserRequest build() {
            return this.request;
        }
    }
}

