/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteStationAssociateduserRequest;
import com.mypurecloud.sdk.v2.api.request.GetStationRequest;
import com.mypurecloud.sdk.v2.api.request.GetStationsRequest;
import com.mypurecloud.sdk.v2.model.Station;
import com.mypurecloud.sdk.v2.model.StationEntityListing;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class StationsApi {
    private final ApiClient pcapiClient;

    public StationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public StationsApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public String deleteStationAssociateduser(String stationId) throws IOException, ApiException {
        return this.deleteStationAssociateduserWithHttpInfo(stationId).getBody();
    }

    public ApiResponse<String> deleteStationAssociateduserWithHttpInfo(String stationId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (stationId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'stationId' when calling deleteStationAssociateduser");
        }
        String pclocalVarPath = "/api/v2/stations/{stationId}/associateduser".replaceAll("\\{format\\}", "json").replaceAll("\\{stationId\\}", this.pcapiClient.escapeString(stationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<String>(){});
    }

    public String deleteStationAssociateduser(DeleteStationAssociateduserRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<String>(){});
    }

    public ApiResponse<String> deleteStationAssociateduser(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<String>(){});
    }

    public Station getStation(String stationId) throws IOException, ApiException {
        return this.getStationWithHttpInfo(stationId).getBody();
    }

    public ApiResponse<Station> getStationWithHttpInfo(String stationId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (stationId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'stationId' when calling getStation");
        }
        String pclocalVarPath = "/api/v2/stations/{stationId}".replaceAll("\\{format\\}", "json").replaceAll("\\{stationId\\}", this.pcapiClient.escapeString(stationId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Station>(){});
    }

    public Station getStation(GetStationRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Station>(){});
    }

    public ApiResponse<Station> getStation(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Station>(){});
    }

    public StationEntityListing getStations(Integer pageSize, Integer pageNumber, String sortBy, String name, String id, String lineAppearanceId) throws IOException, ApiException {
        return this.getStationsWithHttpInfo(pageSize, pageNumber, sortBy, name, id, lineAppearanceId).getBody();
    }

    public ApiResponse<StationEntityListing> getStationsWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, String name, String id, String lineAppearanceId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/stations".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "name", name));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "id", id));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "lineAppearanceId", lineAppearanceId));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<StationEntityListing>(){});
    }

    public StationEntityListing getStations(GetStationsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<StationEntityListing>(){});
    }

    public ApiResponse<StationEntityListing> getStations(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<StationEntityListing>(){});
    }
}

