/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetLocationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLocationsSearchRequest;
import com.mypurecloud.sdk.v2.api.request.PostLocationsSearchRequest;
import com.mypurecloud.sdk.v2.model.LocationDefinition;
import com.mypurecloud.sdk.v2.model.LocationSearchRequest;
import com.mypurecloud.sdk.v2.model.LocationsSearchResponse;
import java.util.List;
import java.util.concurrent.Future;

public class LocationsApiAsync {
    private final ApiClient pcapiClient;

    public LocationsApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public LocationsApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<LocationDefinition> getLocationAsync(GetLocationRequest request, AsyncApiCallback<LocationDefinition> callback) {
        return this.pcapiClient.invokeAPIAsync(request.withHttpInfo(), new TypeReference<LocationDefinition>(){}, callback);
    }

    public Future<ApiResponse<LocationDefinition>> getLocationAsync(ApiRequest<Void> request, AsyncApiCallback<ApiResponse<LocationDefinition>> callback) {
        return this.pcapiClient.invokeAPIVerboseAsync(request, new TypeReference<LocationDefinition>(){}, callback);
    }

    public Future<List<LocationDefinition>> getLocationsAsync(GetLocationsRequest request, AsyncApiCallback<List<LocationDefinition>> callback) {
        return this.pcapiClient.invokeAPIAsync(request.withHttpInfo(), new TypeReference<List<LocationDefinition>>(){}, callback);
    }

    public Future<ApiResponse<List<LocationDefinition>>> getLocationsAsync(ApiRequest<Void> request, AsyncApiCallback<ApiResponse<List<LocationDefinition>>> callback) {
        return this.pcapiClient.invokeAPIVerboseAsync(request, new TypeReference<List<LocationDefinition>>(){}, callback);
    }

    public Future<LocationsSearchResponse> getLocationsSearchAsync(GetLocationsSearchRequest request, AsyncApiCallback<LocationsSearchResponse> callback) {
        return this.pcapiClient.invokeAPIAsync(request.withHttpInfo(), new TypeReference<LocationsSearchResponse>(){}, callback);
    }

    public Future<ApiResponse<LocationsSearchResponse>> getLocationsSearchAsync(ApiRequest<Void> request, AsyncApiCallback<ApiResponse<LocationsSearchResponse>> callback) {
        return this.pcapiClient.invokeAPIVerboseAsync(request, new TypeReference<LocationsSearchResponse>(){}, callback);
    }

    public Future<LocationsSearchResponse> postLocationsSearchAsync(PostLocationsSearchRequest request, AsyncApiCallback<LocationsSearchResponse> callback) {
        return this.pcapiClient.invokeAPIAsync(request.withHttpInfo(), new TypeReference<LocationsSearchResponse>(){}, callback);
    }

    public Future<ApiResponse<LocationsSearchResponse>> postLocationsSearchAsync(ApiRequest<LocationSearchRequest> request, AsyncApiCallback<ApiResponse<LocationsSearchResponse>> callback) {
        return this.pcapiClient.invokeAPIVerboseAsync(request, new TypeReference<LocationsSearchResponse>(){}, callback);
    }
}

