/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Organization;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutOrganizationsMeRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private Organization body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public Organization getBody() {
        return this.body;
    }

    public void setBody(Organization body) {
        this.body = body;
    }

    public PutOrganizationsMeRequest withBody(Organization body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutOrganizationsMeRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Organization> withHttpInfo() {
        return ApiRequestBuilder.create("PUT", "/api/v2/organizations/me").withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final PutOrganizationsMeRequest request = new PutOrganizationsMeRequest();

        private Builder() {
        }

        public Builder withBody(Organization body) {
            this.request.setBody(body);
            return this;
        }

        public PutOrganizationsMeRequest build() {
            return this.request;
        }
    }
}

