/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GetFlowVersionRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String flowId;
    private String versionId;
    private String deleted;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getFlowId() {
        return this.flowId;
    }

    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    public GetFlowVersionRequest withFlowId(String flowId) {
        this.setFlowId(flowId);
        return this;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public GetFlowVersionRequest withVersionId(String versionId) {
        this.setVersionId(versionId);
        return this;
    }

    public String getDeleted() {
        return this.deleted;
    }

    public void setDeleted(String deleted) {
        this.deleted = deleted;
    }

    public GetFlowVersionRequest withDeleted(String deleted) {
        this.setDeleted(deleted);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetFlowVersionRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.flowId == null) {
            throw new IllegalStateException("Missing the required parameter 'flowId' when building request for GetFlowVersionRequest.");
        }
        if (this.versionId == null) {
            throw new IllegalStateException("Missing the required parameter 'versionId' when building request for GetFlowVersionRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/flows/{flowId}/versions/{versionId}").withPathParameter("flowId", this.flowId).withPathParameter("versionId", this.versionId).withQueryParameters("deleted", "", this.deleted).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String flowId, String versionId) {
        return new Builder().withRequiredParams(flowId, versionId);
    }

    public static class Builder {
        private final GetFlowVersionRequest request = new GetFlowVersionRequest();

        private Builder() {
        }

        public Builder withFlowId(String flowId) {
            this.request.setFlowId(flowId);
            return this;
        }

        public Builder withVersionId(String versionId) {
            this.request.setVersionId(versionId);
            return this;
        }

        public Builder withDeleted(String deleted) {
            this.request.setDeleted(deleted);
            return this;
        }

        public Builder withRequiredParams(String flowId, String versionId) {
            this.request.setFlowId(flowId);
            this.request.setVersionId(versionId);
            return this;
        }

        public GetFlowVersionRequest build() {
            return this.request;
        }
    }
}

