/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DeleteRoutingSkillRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String skillId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getSkillId() {
        return this.skillId;
    }

    public void setSkillId(String skillId) {
        this.skillId = skillId;
    }

    public DeleteRoutingSkillRequest withSkillId(String skillId) {
        this.setSkillId(skillId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteRoutingSkillRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.skillId == null) {
            throw new IllegalStateException("Missing the required parameter 'skillId' when building request for DeleteRoutingSkillRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/routing/skills/{skillId}").withPathParameter("skillId", this.skillId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String skillId) {
        return new Builder().withRequiredParams(skillId);
    }

    public static class Builder {
        private final DeleteRoutingSkillRequest request = new DeleteRoutingSkillRequest();

        private Builder() {
        }

        public Builder withSkillId(String skillId) {
            this.request.setSkillId(skillId);
            return this;
        }

        public Builder withRequiredParams(String skillId) {
            this.request.setSkillId(skillId);
            return this;
        }

        public DeleteRoutingSkillRequest build() {
            return this.request;
        }
    }
}

