/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.GetLicenseDefinitionRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseDefinitionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.GetLicenseUserRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseOrganizationRequest;
import com.mypurecloud.sdk.v2.api.request.PostLicenseUsersRequest;
import com.mypurecloud.sdk.v2.model.LicenseBatchAssignmentRequest;
import com.mypurecloud.sdk.v2.model.LicenseDefinition;
import com.mypurecloud.sdk.v2.model.LicenseDefinitionListing;
import com.mypurecloud.sdk.v2.model.LicenseOrganization;
import com.mypurecloud.sdk.v2.model.LicenseUpdateResponse;
import com.mypurecloud.sdk.v2.model.LicenseUser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LicenseApi {
    private final ApiClient pcapiClient;

    public LicenseApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LicenseApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public LicenseDefinition getLicenseDefinition(String licenseId) throws IOException, ApiException {
        return this.getLicenseDefinitionWithHttpInfo(licenseId).getBody();
    }

    public ApiResponse<LicenseDefinition> getLicenseDefinitionWithHttpInfo(String licenseId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (licenseId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'licenseId' when calling getLicenseDefinition");
        }
        String pclocalVarPath = "/api/v2/license/definitions/{licenseId}".replaceAll("\\{format\\}", "json").replaceAll("\\{licenseId\\}", this.pcapiClient.escapeString(licenseId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<LicenseDefinition>(){});
    }

    public LicenseDefinition getLicenseDefinition(GetLicenseDefinitionRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<LicenseDefinition>(){});
    }

    public ApiResponse<LicenseDefinition> getLicenseDefinition(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<LicenseDefinition>(){});
    }

    public LicenseDefinitionListing getLicenseDefinitions() throws IOException, ApiException {
        return this.getLicenseDefinitionsWithHttpInfo().getBody();
    }

    public ApiResponse<LicenseDefinitionListing> getLicenseDefinitionsWithHttpInfo() throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/license/definitions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<LicenseDefinitionListing>(){});
    }

    public LicenseDefinitionListing getLicenseDefinitions(GetLicenseDefinitionsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<LicenseDefinitionListing>(){});
    }

    public ApiResponse<LicenseDefinitionListing> getLicenseDefinitions(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<LicenseDefinitionListing>(){});
    }

    public LicenseOrganization getLicenseOrganization() throws IOException, ApiException {
        return this.getLicenseOrganizationWithHttpInfo().getBody();
    }

    public ApiResponse<LicenseOrganization> getLicenseOrganizationWithHttpInfo() throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/license/organization".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<LicenseOrganization>(){});
    }

    public LicenseOrganization getLicenseOrganization(GetLicenseOrganizationRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<LicenseOrganization>(){});
    }

    public ApiResponse<LicenseOrganization> getLicenseOrganization(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<LicenseOrganization>(){});
    }

    public LicenseUser getLicenseUser(String userId) throws IOException, ApiException {
        return this.getLicenseUserWithHttpInfo(userId).getBody();
    }

    public ApiResponse<LicenseUser> getLicenseUserWithHttpInfo(String userId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling getLicenseUser");
        }
        String pclocalVarPath = "/api/v2/license/users/{userId}".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<LicenseUser>(){});
    }

    public LicenseUser getLicenseUser(GetLicenseUserRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<LicenseUser>(){});
    }

    public ApiResponse<LicenseUser> getLicenseUser(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<LicenseUser>(){});
    }

    public LicenseUpdateResponse postLicenseOrganization(LicenseBatchAssignmentRequest body) throws IOException, ApiException {
        return this.postLicenseOrganizationWithHttpInfo(body).getBody();
    }

    public ApiResponse<LicenseUpdateResponse> postLicenseOrganizationWithHttpInfo(LicenseBatchAssignmentRequest body) throws IOException, ApiException {
        LicenseBatchAssignmentRequest pclocalVarPostBody = body;
        String pclocalVarPath = "/api/v2/license/organization".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<LicenseUpdateResponse>(){});
    }

    public LicenseUpdateResponse postLicenseOrganization(PostLicenseOrganizationRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<LicenseUpdateResponse>(){});
    }

    public ApiResponse<LicenseUpdateResponse> postLicenseOrganization(ApiRequest<LicenseBatchAssignmentRequest> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<LicenseUpdateResponse>(){});
    }

    public Map<String, Object> postLicenseUsers(List<String> body) throws IOException, ApiException {
        return this.postLicenseUsersWithHttpInfo(body).getBody();
    }

    public ApiResponse<Map<String, Object>> postLicenseUsersWithHttpInfo(List<String> body) throws IOException, ApiException {
        List<String> pclocalVarPostBody = body;
        String pclocalVarPath = "/api/v2/license/users".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> postLicenseUsers(PostLicenseUsersRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<Map<String, Object>>(){});
    }

    public ApiResponse<Map<String, Object>> postLicenseUsers(ApiRequest<List<String>> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<Map<String, Object>>(){});
    }
}

