/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.Button;
import com.mypurecloud.sdk.v2.model.MessageFooter;
import com.mypurecloud.sdk.v2.model.MessageHeader;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A WhatsApp messaging template definition as defined in the WhatsApp Business Manager")
public class WhatsAppDefinition
implements Serializable {
    private String name = null;
    private String namespace = null;
    private String language = null;
    private List<Button> buttons = null;
    private MessageFooter messageFooter = null;
    private MessageHeader header = null;

    public WhatsAppDefinition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.buttons = new ArrayList<Button>();
        }
    }

    public WhatsAppDefinition name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging template name.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WhatsAppDefinition namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @ApiModelProperty(example="null", value="The messaging template namespace.")
    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public WhatsAppDefinition language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging template language configured for this template. This is a WhatsApp specific value. For example, 'en_US'")
    @JsonProperty(value="language")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public WhatsAppDefinition buttons(List<Button> buttons) {
        this.buttons = buttons;
        return this;
    }

    @ApiModelProperty(example="null", value="List of buttons to be included in the WhatsApp messages channel")
    @JsonProperty(value="buttons")
    public List<Button> getButtons() {
        return this.buttons;
    }

    public void setButtons(List<Button> buttons) {
        this.buttons = buttons;
    }

    public WhatsAppDefinition messageFooter(MessageFooter messageFooter) {
        this.messageFooter = messageFooter;
        return this;
    }

    @ApiModelProperty(example="null", value="Footer for the message in the WhatsApp messages channel")
    @JsonProperty(value="messageFooter")
    public MessageFooter getMessageFooter() {
        return this.messageFooter;
    }

    public void setMessageFooter(MessageFooter messageFooter) {
        this.messageFooter = messageFooter;
    }

    public WhatsAppDefinition header(MessageHeader header) {
        this.header = header;
        return this;
    }

    @ApiModelProperty(example="null", value="Header for the message in the WhatsApp messages channel")
    @JsonProperty(value="header")
    public MessageHeader getHeader() {
        return this.header;
    }

    public void setHeader(MessageHeader header) {
        this.header = header;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsAppDefinition whatsAppDefinition = (WhatsAppDefinition)o;
        return Objects.equals(this.name, whatsAppDefinition.name) && Objects.equals(this.namespace, whatsAppDefinition.namespace) && Objects.equals(this.language, whatsAppDefinition.language) && Objects.equals(this.buttons, whatsAppDefinition.buttons) && Objects.equals(this.messageFooter, whatsAppDefinition.messageFooter) && Objects.equals(this.header, whatsAppDefinition.header);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.namespace, this.language, this.buttons, this.messageFooter, this.header);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsAppDefinition {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    buttons: ").append(this.toIndentedString(this.buttons)).append("\n");
        sb.append("    messageFooter: ").append(this.toIndentedString(this.messageFooter)).append("\n");
        sb.append("    header: ").append(this.toIndentedString(this.header)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

