/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.SegmentAssignmentSegment;
import com.mypurecloud.sdk.v2.model.SegmentAssignmentSession;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class SegmentAssignment
implements Serializable {
    private Date dateAssigned = null;
    private Date dateForUnassignment = null;
    private SegmentAssignmentSegment segment = null;
    private AddressableEntityRef externalContact = null;
    private SegmentAssignmentSession session = null;

    public SegmentAssignment() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public SegmentAssignment dateAssigned(Date dateAssigned) {
        this.dateAssigned = dateAssigned;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date when the segment was assigned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateAssigned")
    public Date getDateAssigned() {
        return this.dateAssigned;
    }

    public void setDateAssigned(Date dateAssigned) {
        this.dateAssigned = dateAssigned;
    }

    public SegmentAssignment dateForUnassignment(Date dateForUnassignment) {
        this.dateForUnassignment = dateForUnassignment;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Date indicating when a segment is scheduled to be unassigned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateForUnassignment")
    public Date getDateForUnassignment() {
        return this.dateForUnassignment;
    }

    public void setDateForUnassignment(Date dateForUnassignment) {
        this.dateForUnassignment = dateForUnassignment;
    }

    public SegmentAssignment segment(SegmentAssignmentSegment segment) {
        this.segment = segment;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The segment the assignment is for.")
    @JsonProperty(value="segment")
    public SegmentAssignmentSegment getSegment() {
        return this.segment;
    }

    public void setSegment(SegmentAssignmentSegment segment) {
        this.segment = segment;
    }

    public SegmentAssignment externalContact(AddressableEntityRef externalContact) {
        this.externalContact = externalContact;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="External contact of the customer to which the segment is assigned.")
    @JsonProperty(value="externalContact")
    public AddressableEntityRef getExternalContact() {
        return this.externalContact;
    }

    public void setExternalContact(AddressableEntityRef externalContact) {
        this.externalContact = externalContact;
    }

    public SegmentAssignment session(SegmentAssignmentSession session) {
        this.session = session;
        return this;
    }

    @ApiModelProperty(example="null", value="For session-scoped segments, the session for which the segment was assigned.")
    @JsonProperty(value="session")
    public SegmentAssignmentSession getSession() {
        return this.session;
    }

    public void setSession(SegmentAssignmentSession session) {
        this.session = session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentAssignment segmentAssignment = (SegmentAssignment)o;
        return Objects.equals(this.dateAssigned, segmentAssignment.dateAssigned) && Objects.equals(this.dateForUnassignment, segmentAssignment.dateForUnassignment) && Objects.equals(this.segment, segmentAssignment.segment) && Objects.equals(this.externalContact, segmentAssignment.externalContact) && Objects.equals(this.session, segmentAssignment.session);
    }

    public int hashCode() {
        return Objects.hash(this.dateAssigned, this.dateForUnassignment, this.segment, this.externalContact, this.session);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SegmentAssignment {\n");
        sb.append("    dateAssigned: ").append(this.toIndentedString(this.dateAssigned)).append("\n");
        sb.append("    dateForUnassignment: ").append(this.toIndentedString(this.dateForUnassignment)).append("\n");
        sb.append("    segment: ").append(this.toIndentedString(this.segment)).append("\n");
        sb.append("    externalContact: ").append(this.toIndentedString(this.externalContact)).append("\n");
        sb.append("    session: ").append(this.toIndentedString(this.session)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

