/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.ButtonResponse;
import com.mypurecloud.sdk.v2.model.Card;
import com.mypurecloud.sdk.v2.model.ConversationMessageEvent;
import com.mypurecloud.sdk.v2.model.DatePicker;
import com.mypurecloud.sdk.v2.model.ExternalContact;
import com.mypurecloud.sdk.v2.model.InteractiveApplication;
import com.mypurecloud.sdk.v2.model.ListPicker;
import com.mypurecloud.sdk.v2.model.MessageMediaAttachment;
import com.mypurecloud.sdk.v2.model.MessageStickerAttachment;
import com.mypurecloud.sdk.v2.model.PaymentRequest;
import com.mypurecloud.sdk.v2.model.PaymentResponse;
import com.mypurecloud.sdk.v2.model.QuickReply;
import com.mypurecloud.sdk.v2.model.RecordingContentStory;
import com.mypurecloud.sdk.v2.model.RecordingForm;
import com.mypurecloud.sdk.v2.model.RecordingNotificationTemplate;
import com.mypurecloud.sdk.v2.model.RecordingRoadsideAssistance;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RecordingMessagingMessage
implements Serializable {
    private String from = null;
    private User fromUser = null;
    private ExternalContact fromExternalContact = null;
    private String to = null;
    private Date timestamp = null;
    private String id = null;
    private String purpose = null;
    private String participantId = null;
    private AddressableEntityRef queue = null;
    private AddressableEntityRef workflow = null;
    private String messageText = null;
    private List<MessageMediaAttachment> messageMediaAttachments = null;
    private List<MessageStickerAttachment> messageStickerAttachments = null;
    private List<QuickReply> quickReplies = null;
    private ButtonResponse buttonResponse = null;
    private List<ButtonResponse> buttonResponses = null;
    private RecordingContentStory story = null;
    private List<Card> cards = null;
    private RecordingNotificationTemplate notificationTemplate = null;
    private DatePicker datePicker = null;
    private ListPicker listPicker = null;
    private ContentTypeEnum contentType = null;
    private SocialVisibilityEnum socialVisibility = null;
    private List<ConversationMessageEvent> events = null;
    private InteractiveApplication interactiveApplication = null;
    private PaymentRequest paymentRequest = null;
    private PaymentResponse paymentResponse = null;
    private RecordingForm form = null;
    private RecordingRoadsideAssistance roadsideAssistance = null;

    public RecordingMessagingMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.messageMediaAttachments = new ArrayList<MessageMediaAttachment>();
            this.messageStickerAttachments = new ArrayList<MessageStickerAttachment>();
            this.quickReplies = new ArrayList<QuickReply>();
            this.buttonResponses = new ArrayList<ButtonResponse>();
            this.cards = new ArrayList<Card>();
            this.events = new ArrayList<ConversationMessageEvent>();
        }
    }

    public RecordingMessagingMessage from(String from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", value="The message sender session id.")
    @JsonProperty(value="from")
    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public RecordingMessagingMessage fromUser(User fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    @ApiModelProperty(example="null", value="The user who sent this message.")
    @JsonProperty(value="fromUser")
    public User getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(User fromUser) {
        this.fromUser = fromUser;
    }

    public RecordingMessagingMessage fromExternalContact(ExternalContact fromExternalContact) {
        this.fromExternalContact = fromExternalContact;
        return this;
    }

    @ApiModelProperty(example="null", value="The PureCloud external contact sender details.")
    @JsonProperty(value="fromExternalContact")
    public ExternalContact getFromExternalContact() {
        return this.fromExternalContact;
    }

    public void setFromExternalContact(ExternalContact fromExternalContact) {
        this.fromExternalContact = fromExternalContact;
    }

    public RecordingMessagingMessage to(String to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", value="The message recipient.")
    @JsonProperty(value="to")
    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public RecordingMessagingMessage timestamp(Date timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the message was sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="timestamp")
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public RecordingMessagingMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for this communication.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RecordingMessagingMessage purpose(String purpose) {
        this.purpose = purpose;
        return this;
    }

    @ApiModelProperty(example="null", value="A well known string that specifies the purpose or type of the participant on this communication.")
    @JsonProperty(value="purpose")
    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public RecordingMessagingMessage participantId(String participantId) {
        this.participantId = participantId;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the participant on this communication.")
    @JsonProperty(value="participantId")
    public String getParticipantId() {
        return this.participantId;
    }

    public void setParticipantId(String participantId) {
        this.participantId = participantId;
    }

    public RecordingMessagingMessage queue(AddressableEntityRef queue) {
        this.queue = queue;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the queue involved in this communication.")
    @JsonProperty(value="queue")
    public AddressableEntityRef getQueue() {
        return this.queue;
    }

    public void setQueue(AddressableEntityRef queue) {
        this.queue = queue;
    }

    public RecordingMessagingMessage workflow(AddressableEntityRef workflow) {
        this.workflow = workflow;
        return this;
    }

    @ApiModelProperty(example="null", value="A globally unique identifier for the workflow involved in this communication.")
    @JsonProperty(value="workflow")
    public AddressableEntityRef getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(AddressableEntityRef workflow) {
        this.workflow = workflow;
    }

    public RecordingMessagingMessage messageText(String messageText) {
        this.messageText = messageText;
        return this;
    }

    @ApiModelProperty(example="null", value="The content of this message.")
    @JsonProperty(value="messageText")
    public String getMessageText() {
        return this.messageText;
    }

    public void setMessageText(String messageText) {
        this.messageText = messageText;
    }

    public RecordingMessagingMessage messageMediaAttachments(List<MessageMediaAttachment> messageMediaAttachments) {
        this.messageMediaAttachments = messageMediaAttachments;
        return this;
    }

    @ApiModelProperty(example="null", value="List of media objects attached  with this message.")
    @JsonProperty(value="messageMediaAttachments")
    public List<MessageMediaAttachment> getMessageMediaAttachments() {
        return this.messageMediaAttachments;
    }

    public void setMessageMediaAttachments(List<MessageMediaAttachment> messageMediaAttachments) {
        this.messageMediaAttachments = messageMediaAttachments;
    }

    public RecordingMessagingMessage messageStickerAttachments(List<MessageStickerAttachment> messageStickerAttachments) {
        this.messageStickerAttachments = messageStickerAttachments;
        return this;
    }

    @ApiModelProperty(example="null", value="List of message stickers attached with this message.")
    @JsonProperty(value="messageStickerAttachments")
    public List<MessageStickerAttachment> getMessageStickerAttachments() {
        return this.messageStickerAttachments;
    }

    public void setMessageStickerAttachments(List<MessageStickerAttachment> messageStickerAttachments) {
        this.messageStickerAttachments = messageStickerAttachments;
    }

    public RecordingMessagingMessage quickReplies(List<QuickReply> quickReplies) {
        this.quickReplies = quickReplies;
        return this;
    }

    @ApiModelProperty(example="null", value="List of quick reply options offered with this message.")
    @JsonProperty(value="quickReplies")
    public List<QuickReply> getQuickReplies() {
        return this.quickReplies;
    }

    public void setQuickReplies(List<QuickReply> quickReplies) {
        this.quickReplies = quickReplies;
    }

    public RecordingMessagingMessage buttonResponse(ButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Button Response selected by user for this message.")
    @JsonProperty(value="buttonResponse")
    public ButtonResponse getButtonResponse() {
        return this.buttonResponse;
    }

    public void setButtonResponse(ButtonResponse buttonResponse) {
        this.buttonResponse = buttonResponse;
    }

    public RecordingMessagingMessage buttonResponses(List<ButtonResponse> buttonResponses) {
        this.buttonResponses = buttonResponses;
        return this;
    }

    @ApiModelProperty(example="null", value="List of Button Response selected by user for this message.")
    @JsonProperty(value="buttonResponses")
    public List<ButtonResponse> getButtonResponses() {
        return this.buttonResponses;
    }

    public void setButtonResponses(List<ButtonResponse> buttonResponses) {
        this.buttonResponses = buttonResponses;
    }

    public RecordingMessagingMessage story(RecordingContentStory story) {
        this.story = story;
        return this;
    }

    @ApiModelProperty(example="null", value="Ephemeral story content.")
    @JsonProperty(value="story")
    public RecordingContentStory getStory() {
        return this.story;
    }

    public void setStory(RecordingContentStory story) {
        this.story = story;
    }

    public RecordingMessagingMessage cards(List<Card> cards) {
        this.cards = cards;
        return this;
    }

    @ApiModelProperty(example="null", value="List of cards offered for this message")
    @JsonProperty(value="cards")
    public List<Card> getCards() {
        return this.cards;
    }

    public void setCards(List<Card> cards) {
        this.cards = cards;
    }

    public RecordingMessagingMessage notificationTemplate(RecordingNotificationTemplate notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="Template notification content.")
    @JsonProperty(value="notificationTemplate")
    public RecordingNotificationTemplate getNotificationTemplate() {
        return this.notificationTemplate;
    }

    public void setNotificationTemplate(RecordingNotificationTemplate notificationTemplate) {
        this.notificationTemplate = notificationTemplate;
    }

    public RecordingMessagingMessage datePicker(DatePicker datePicker) {
        this.datePicker = datePicker;
        return this;
    }

    @ApiModelProperty(example="null", value="DatePicker content object.")
    @JsonProperty(value="datePicker")
    public DatePicker getDatePicker() {
        return this.datePicker;
    }

    public void setDatePicker(DatePicker datePicker) {
        this.datePicker = datePicker;
    }

    public RecordingMessagingMessage listPicker(ListPicker listPicker) {
        this.listPicker = listPicker;
        return this;
    }

    @ApiModelProperty(example="null", value="ListPicker content object.")
    @JsonProperty(value="listPicker")
    public ListPicker getListPicker() {
        return this.listPicker;
    }

    public void setListPicker(ListPicker listPicker) {
        this.listPicker = listPicker;
    }

    public RecordingMessagingMessage contentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the content type for this message")
    @JsonProperty(value="contentType")
    public ContentTypeEnum getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentTypeEnum contentType) {
        this.contentType = contentType;
    }

    public RecordingMessagingMessage socialVisibility(SocialVisibilityEnum socialVisibility) {
        this.socialVisibility = socialVisibility;
        return this;
    }

    @ApiModelProperty(example="null", value="For social media messages, the visibility of the message in the originating social platform")
    @JsonProperty(value="socialVisibility")
    public SocialVisibilityEnum getSocialVisibility() {
        return this.socialVisibility;
    }

    public void setSocialVisibility(SocialVisibilityEnum socialVisibility) {
        this.socialVisibility = socialVisibility;
    }

    public RecordingMessagingMessage events(List<ConversationMessageEvent> events) {
        this.events = events;
        return this;
    }

    @ApiModelProperty(example="null", value="List of event elements")
    @JsonProperty(value="events")
    public List<ConversationMessageEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<ConversationMessageEvent> events) {
        this.events = events;
    }

    public RecordingMessagingMessage interactiveApplication(InteractiveApplication interactiveApplication) {
        this.interactiveApplication = interactiveApplication;
        return this;
    }

    @ApiModelProperty(example="null", value="InteractiveApplication content.")
    @JsonProperty(value="interactiveApplication")
    public InteractiveApplication getInteractiveApplication() {
        return this.interactiveApplication;
    }

    public void setInteractiveApplication(InteractiveApplication interactiveApplication) {
        this.interactiveApplication = interactiveApplication;
    }

    public RecordingMessagingMessage paymentRequest(PaymentRequest paymentRequest) {
        this.paymentRequest = paymentRequest;
        return this;
    }

    @ApiModelProperty(example="null", value="Payment request content.")
    @JsonProperty(value="paymentRequest")
    public PaymentRequest getPaymentRequest() {
        return this.paymentRequest;
    }

    public void setPaymentRequest(PaymentRequest paymentRequest) {
        this.paymentRequest = paymentRequest;
    }

    public RecordingMessagingMessage paymentResponse(PaymentResponse paymentResponse) {
        this.paymentResponse = paymentResponse;
        return this;
    }

    @ApiModelProperty(example="null", value="Payment response content.")
    @JsonProperty(value="paymentResponse")
    public PaymentResponse getPaymentResponse() {
        return this.paymentResponse;
    }

    public void setPaymentResponse(PaymentResponse paymentResponse) {
        this.paymentResponse = paymentResponse;
    }

    public RecordingMessagingMessage form(RecordingForm form) {
        this.form = form;
        return this;
    }

    @ApiModelProperty(example="null", value="Form content.")
    @JsonProperty(value="form")
    public RecordingForm getForm() {
        return this.form;
    }

    public void setForm(RecordingForm form) {
        this.form = form;
    }

    public RecordingMessagingMessage roadsideAssistance(RecordingRoadsideAssistance roadsideAssistance) {
        this.roadsideAssistance = roadsideAssistance;
        return this;
    }

    @ApiModelProperty(example="null", value="Roadside Assistance content.")
    @JsonProperty(value="roadsideAssistance")
    public RecordingRoadsideAssistance getRoadsideAssistance() {
        return this.roadsideAssistance;
    }

    public void setRoadsideAssistance(RecordingRoadsideAssistance roadsideAssistance) {
        this.roadsideAssistance = roadsideAssistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingMessagingMessage recordingMessagingMessage = (RecordingMessagingMessage)o;
        return Objects.equals(this.from, recordingMessagingMessage.from) && Objects.equals(this.fromUser, recordingMessagingMessage.fromUser) && Objects.equals(this.fromExternalContact, recordingMessagingMessage.fromExternalContact) && Objects.equals(this.to, recordingMessagingMessage.to) && Objects.equals(this.timestamp, recordingMessagingMessage.timestamp) && Objects.equals(this.id, recordingMessagingMessage.id) && Objects.equals(this.purpose, recordingMessagingMessage.purpose) && Objects.equals(this.participantId, recordingMessagingMessage.participantId) && Objects.equals(this.queue, recordingMessagingMessage.queue) && Objects.equals(this.workflow, recordingMessagingMessage.workflow) && Objects.equals(this.messageText, recordingMessagingMessage.messageText) && Objects.equals(this.messageMediaAttachments, recordingMessagingMessage.messageMediaAttachments) && Objects.equals(this.messageStickerAttachments, recordingMessagingMessage.messageStickerAttachments) && Objects.equals(this.quickReplies, recordingMessagingMessage.quickReplies) && Objects.equals(this.buttonResponse, recordingMessagingMessage.buttonResponse) && Objects.equals(this.buttonResponses, recordingMessagingMessage.buttonResponses) && Objects.equals(this.story, recordingMessagingMessage.story) && Objects.equals(this.cards, recordingMessagingMessage.cards) && Objects.equals(this.notificationTemplate, recordingMessagingMessage.notificationTemplate) && Objects.equals(this.datePicker, recordingMessagingMessage.datePicker) && Objects.equals(this.listPicker, recordingMessagingMessage.listPicker) && Objects.equals((Object)this.contentType, (Object)recordingMessagingMessage.contentType) && Objects.equals((Object)this.socialVisibility, (Object)recordingMessagingMessage.socialVisibility) && Objects.equals(this.events, recordingMessagingMessage.events) && Objects.equals(this.interactiveApplication, recordingMessagingMessage.interactiveApplication) && Objects.equals(this.paymentRequest, recordingMessagingMessage.paymentRequest) && Objects.equals(this.paymentResponse, recordingMessagingMessage.paymentResponse) && Objects.equals(this.form, recordingMessagingMessage.form) && Objects.equals(this.roadsideAssistance, recordingMessagingMessage.roadsideAssistance);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.fromUser, this.fromExternalContact, this.to, this.timestamp, this.id, this.purpose, this.participantId, this.queue, this.workflow, this.messageText, this.messageMediaAttachments, this.messageStickerAttachments, this.quickReplies, this.buttonResponse, this.buttonResponses, this.story, this.cards, this.notificationTemplate, this.datePicker, this.listPicker, this.contentType, this.socialVisibility, this.events, this.interactiveApplication, this.paymentRequest, this.paymentResponse, this.form, this.roadsideAssistance});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingMessagingMessage {\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    fromUser: ").append(this.toIndentedString(this.fromUser)).append("\n");
        sb.append("    fromExternalContact: ").append(this.toIndentedString(this.fromExternalContact)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString(this.purpose)).append("\n");
        sb.append("    participantId: ").append(this.toIndentedString(this.participantId)).append("\n");
        sb.append("    queue: ").append(this.toIndentedString(this.queue)).append("\n");
        sb.append("    workflow: ").append(this.toIndentedString(this.workflow)).append("\n");
        sb.append("    messageText: ").append(this.toIndentedString(this.messageText)).append("\n");
        sb.append("    messageMediaAttachments: ").append(this.toIndentedString(this.messageMediaAttachments)).append("\n");
        sb.append("    messageStickerAttachments: ").append(this.toIndentedString(this.messageStickerAttachments)).append("\n");
        sb.append("    quickReplies: ").append(this.toIndentedString(this.quickReplies)).append("\n");
        sb.append("    buttonResponse: ").append(this.toIndentedString(this.buttonResponse)).append("\n");
        sb.append("    buttonResponses: ").append(this.toIndentedString(this.buttonResponses)).append("\n");
        sb.append("    story: ").append(this.toIndentedString(this.story)).append("\n");
        sb.append("    cards: ").append(this.toIndentedString(this.cards)).append("\n");
        sb.append("    notificationTemplate: ").append(this.toIndentedString(this.notificationTemplate)).append("\n");
        sb.append("    datePicker: ").append(this.toIndentedString(this.datePicker)).append("\n");
        sb.append("    listPicker: ").append(this.toIndentedString(this.listPicker)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString((Object)this.contentType)).append("\n");
        sb.append("    socialVisibility: ").append(this.toIndentedString((Object)this.socialVisibility)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    interactiveApplication: ").append(this.toIndentedString(this.interactiveApplication)).append("\n");
        sb.append("    paymentRequest: ").append(this.toIndentedString(this.paymentRequest)).append("\n");
        sb.append("    paymentResponse: ").append(this.toIndentedString(this.paymentResponse)).append("\n");
        sb.append("    form: ").append(this.toIndentedString(this.form)).append("\n");
        sb.append("    roadsideAssistance: ").append(this.toIndentedString(this.roadsideAssistance)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContentTypeEnumDeserializer.class)
    public static enum ContentTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUICKREPLY("QuickReply"),
        STORY("Story"),
        CARD("Card"),
        CAROUSEL("Carousel"),
        ATTACHMENT("Attachment"),
        LOCATION("Location"),
        NOTIFICATION("Notification"),
        GENERICTEMPLATE("GenericTemplate"),
        LISTTEMPLATE("ListTemplate"),
        POSTBACK("Postback"),
        REACTIONS("Reactions"),
        MENTION("Mention"),
        BUTTONRESPONSE("ButtonResponse"),
        DATEPICKER("DatePicker"),
        LISTPICKER("ListPicker"),
        INTERACTIVEAPPLICATION("InteractiveApplication"),
        PAYMENTREQUEST("PaymentRequest"),
        PAYMENTRESPONSE("PaymentResponse"),
        FORM("Form"),
        RICHLINK("RichLink"),
        ROADSIDEASSISTANCE("RoadsideAssistance");

        private String value;

        private ContentTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContentTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContentTypeEnum value : ContentTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContentTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SocialVisibilityEnumDeserializer.class)
    public static enum SocialVisibilityEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PUBLIC("Public"),
        PRIVATE("Private");

        private String value;

        private SocialVisibilityEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SocialVisibilityEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SocialVisibilityEnum value : SocialVisibilityEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SocialVisibilityEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SocialVisibilityEnumDeserializer
    extends StdDeserializer<SocialVisibilityEnum> {
        public SocialVisibilityEnumDeserializer() {
            super(SocialVisibilityEnumDeserializer.class);
        }

        public SocialVisibilityEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SocialVisibilityEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class ContentTypeEnumDeserializer
    extends StdDeserializer<ContentTypeEnum> {
        public ContentTypeEnumDeserializer() {
            super(ContentTypeEnumDeserializer.class);
        }

        public ContentTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContentTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

