/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.OpenSocialMediaRecipient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Channel-specific information that describes the message and the message channel/provider.")
public class OpenSocialMediaReactionsChannel
implements Serializable {
    private String id = null;
    private PlatformEnum platform = null;
    private TypeEnum type = null;
    private String messageId = null;
    private OpenSocialMediaRecipient to = null;
    private Date time = null;

    public OpenSocialMediaReactionsChannel() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The topic ID.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The provider type.")
    @JsonProperty(value="platform")
    public PlatformEnum getPlatform() {
        return this.platform;
    }

    @ApiModelProperty(example="null", value="Specifies if this message is part of a private or public conversation.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public OpenSocialMediaReactionsChannel messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Unique provider ID of the message such as a Open message ID.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @ApiModelProperty(example="null", value="Information about the recipient the message is sent to.")
    @JsonProperty(value="to")
    public OpenSocialMediaRecipient getTo() {
        return this.to;
    }

    public OpenSocialMediaReactionsChannel time(Date time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Original time of the event. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSocialMediaReactionsChannel openSocialMediaReactionsChannel = (OpenSocialMediaReactionsChannel)o;
        return Objects.equals(this.id, openSocialMediaReactionsChannel.id) && Objects.equals((Object)this.platform, (Object)openSocialMediaReactionsChannel.platform) && Objects.equals((Object)this.type, (Object)openSocialMediaReactionsChannel.type) && Objects.equals(this.messageId, openSocialMediaReactionsChannel.messageId) && Objects.equals(this.to, openSocialMediaReactionsChannel.to) && Objects.equals(this.time, openSocialMediaReactionsChannel.time);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.platform, this.type, this.messageId, this.to, this.time});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenSocialMediaReactionsChannel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    platform: ").append(this.toIndentedString((Object)this.platform)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=PlatformEnumDeserializer.class)
    public static enum PlatformEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OPEN("Open");

        private String value;

        private PlatformEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PlatformEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PlatformEnum value : PlatformEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PlatformEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PUBLIC("Public");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class PlatformEnumDeserializer
    extends StdDeserializer<PlatformEnum> {
        public PlatformEnumDeserializer() {
            super(PlatformEnumDeserializer.class);
        }

        public PlatformEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PlatformEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

