/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Input component configuration")
public class Input
implements Serializable {
    private String id = null;
    private String title = null;
    private String subtitle = null;
    private String placeholderText = null;
    private Boolean isMultipleLine = null;
    private Boolean isRequired = null;
    private KeyboardTypeEnum keyboardType = null;
    private AutoCompleteTypeEnum autoCompleteType = null;

    public Input() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public Input id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the input field")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Input title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="Title of the input field")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Input subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @ApiModelProperty(example="null", value="Subtitle of the input field")
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public Input placeholderText(String placeholderText) {
        this.placeholderText = placeholderText;
        return this;
    }

    @ApiModelProperty(example="null", value="Placeholder text for the input")
    @JsonProperty(value="placeholderText")
    public String getPlaceholderText() {
        return this.placeholderText;
    }

    public void setPlaceholderText(String placeholderText) {
        this.placeholderText = placeholderText;
    }

    public Input isMultipleLine(Boolean isMultipleLine) {
        this.isMultipleLine = isMultipleLine;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the input supports multiple lines")
    @JsonProperty(value="isMultipleLine")
    public Boolean getIsMultipleLine() {
        return this.isMultipleLine;
    }

    public void setIsMultipleLine(Boolean isMultipleLine) {
        this.isMultipleLine = isMultipleLine;
    }

    public Input isRequired(Boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the input is required")
    @JsonProperty(value="isRequired")
    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public Input keyboardType(KeyboardTypeEnum keyboardType) {
        this.keyboardType = keyboardType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of keyboard to be shown")
    @JsonProperty(value="keyboardType")
    public KeyboardTypeEnum getKeyboardType() {
        return this.keyboardType;
    }

    public void setKeyboardType(KeyboardTypeEnum keyboardType) {
        this.keyboardType = keyboardType;
    }

    public Input autoCompleteType(AutoCompleteTypeEnum autoCompleteType) {
        this.autoCompleteType = autoCompleteType;
        return this;
    }

    @ApiModelProperty(example="null", value="A string value representing the keyboard and system information about the expected semantic meaning for the content that users enter")
    @JsonProperty(value="autoCompleteType")
    public AutoCompleteTypeEnum getAutoCompleteType() {
        return this.autoCompleteType;
    }

    public void setAutoCompleteType(AutoCompleteTypeEnum autoCompleteType) {
        this.autoCompleteType = autoCompleteType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Input input = (Input)o;
        return Objects.equals(this.id, input.id) && Objects.equals(this.title, input.title) && Objects.equals(this.subtitle, input.subtitle) && Objects.equals(this.placeholderText, input.placeholderText) && Objects.equals(this.isMultipleLine, input.isMultipleLine) && Objects.equals(this.isRequired, input.isRequired) && Objects.equals((Object)this.keyboardType, (Object)input.keyboardType) && Objects.equals((Object)this.autoCompleteType, (Object)input.autoCompleteType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, this.subtitle, this.placeholderText, this.isMultipleLine, this.isRequired, this.keyboardType, this.autoCompleteType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Input {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    subtitle: ").append(this.toIndentedString(this.subtitle)).append("\n");
        sb.append("    placeholderText: ").append(this.toIndentedString(this.placeholderText)).append("\n");
        sb.append("    isMultipleLine: ").append(this.toIndentedString(this.isMultipleLine)).append("\n");
        sb.append("    isRequired: ").append(this.toIndentedString(this.isRequired)).append("\n");
        sb.append("    keyboardType: ").append(this.toIndentedString((Object)this.keyboardType)).append("\n");
        sb.append("    autoCompleteType: ").append(this.toIndentedString((Object)this.autoCompleteType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=KeyboardTypeEnumDeserializer.class)
    public static enum KeyboardTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DEFAULT("Default"),
        NUMBERPUNCTUATION("NumberPunctuation"),
        NUMBER("Number"),
        PHONE("Phone"),
        EMAIL("Email"),
        DECIMAL("Decimal"),
        WEBSEARCH("Websearch"),
        URL("URL");

        private String value;

        private KeyboardTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static KeyboardTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (KeyboardTypeEnum value : KeyboardTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return KeyboardTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=AutoCompleteTypeEnumDeserializer.class)
    public static enum AutoCompleteTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PREFIX("Prefix"),
        NAME("Name"),
        GIVENNAME("GivenName"),
        MIDDLENAME("MiddleName"),
        FAMILYNAME("FamilyName"),
        SUFFIX("Suffix"),
        NICKNAME("Nickname"),
        TITLE("Title"),
        ORGANIZATION("Organization"),
        LOCATION("Location"),
        STREETADDRESS("StreetAddress"),
        ADDRESSLINE1("Addressline1"),
        ADDRESSLINE2("Addressline2"),
        CITY("City"),
        STATE("State"),
        COUNTRY("Country"),
        POSTALCODE("PostalCode"),
        USERNAME("Username"),
        ONETIMECODE("OneTimeCode"),
        EMAIL("Email"),
        PHONE("Phone"),
        PAYMENTCARDNUMBER("PaymentCardNumber"),
        PAYMENTCARDEXPIRATION("PaymentCardExpiration"),
        PAYMENTCARDEXPIRATIONMONTH("PaymentCardExpirationMonth"),
        PAYMENTCARDEXPIRATIONYEAR("PaymentCardExpirationYear"),
        PAYMENTCARDSECURITYCODE("PaymentCardSecurityCode"),
        PAYMENTCARDTYPE("PaymentCardType"),
        PAYMENTCARDNAME("PaymentCardName"),
        PAYMENTCARDGIVENNAME("PaymentCardGivenName"),
        PAYMENTCARDMIDDLENAME("PaymentCardMiddleName"),
        PAYMENTCARDFAMILYNAME("PaymentCardFamilyName"),
        BIRTHDATE("Birthdate"),
        BIRTHDATEDAY("BirthdateDay"),
        BIRTHDATEMONTH("BirthdateMonth"),
        BIRTHDATEYEAR("BirthdateYear"),
        DATETIME("DateTime"),
        FLIGHTNUMBER("FlightNumber"),
        URL("Url");

        private String value;

        private AutoCompleteTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoCompleteTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoCompleteTypeEnum value : AutoCompleteTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoCompleteTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoCompleteTypeEnumDeserializer
    extends StdDeserializer<AutoCompleteTypeEnum> {
        public AutoCompleteTypeEnumDeserializer() {
            super(AutoCompleteTypeEnumDeserializer.class);
        }

        public AutoCompleteTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoCompleteTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class KeyboardTypeEnumDeserializer
    extends StdDeserializer<KeyboardTypeEnum> {
        public KeyboardTypeEnumDeserializer() {
            super(KeyboardTypeEnumDeserializer.class);
        }

        public KeyboardTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return KeyboardTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

