/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CustomerIntentAssignmentRequest
implements Serializable {
    private String sourceId = null;
    private String sessionId = null;
    private String conversationId = null;
    private SourceTypeEnum sourceType = null;

    public CustomerIntentAssignmentRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CustomerIntentAssignmentRequest sourceId(String sourceId) {
        this.sourceId = sourceId;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of the source of assignment")
    @JsonProperty(value="sourceId")
    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public CustomerIntentAssignmentRequest sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of session assignment occurred in")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public CustomerIntentAssignmentRequest conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of conversation assignment occurred in")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public CustomerIntentAssignmentRequest sourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of source of assignment")
    @JsonProperty(value="sourceType")
    public SourceTypeEnum getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerIntentAssignmentRequest customerIntentAssignmentRequest = (CustomerIntentAssignmentRequest)o;
        return Objects.equals(this.sourceId, customerIntentAssignmentRequest.sourceId) && Objects.equals(this.sessionId, customerIntentAssignmentRequest.sessionId) && Objects.equals(this.conversationId, customerIntentAssignmentRequest.conversationId) && Objects.equals((Object)this.sourceType, (Object)customerIntentAssignmentRequest.sourceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourceId, this.sessionId, this.conversationId, this.sourceType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerIntentAssignmentRequest {\n");
        sb.append("    sourceId: ").append(this.toIndentedString(this.sourceId)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString((Object)this.sourceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SourceTypeEnumDeserializer.class)
    public static enum SourceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BOT("Bot"),
        COPILOT("Copilot"),
        DIGITALBOT("Digitalbot"),
        SEGMENT("Segment"),
        TOPIC("Topic"),
        UNKNOWN("Unknown");

        private String value;

        private SourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourceTypeEnum value : SourceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourceTypeEnumDeserializer
    extends StdDeserializer<SourceTypeEnum> {
        public SourceTypeEnumDeserializer() {
            super(SourceTypeEnumDeserializer.class);
        }

        public SourceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

