/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class ChecklistItem
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Boolean automatedCheckEnabled = null;
    private Boolean important = null;
    private StateFromModelEnum stateFromModel = null;
    private StateFromAgentEnum stateFromAgent = null;
    private Date dateLastModifiedByModel = null;
    private Date dateLastModifiedByAgent = null;
    private Boolean lastModifiedInAcw = null;
    private String selfUri = null;

    public ChecklistItem() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ChecklistItem id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="ID of the checklist item.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ChecklistItem name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Name of the checklist item.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ChecklistItem description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Description of the checklist item.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ChecklistItem automatedCheckEnabled(Boolean automatedCheckEnabled) {
        this.automatedCheckEnabled = automatedCheckEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to indicate whether automated check is enabled for this checklist item.")
    @JsonProperty(value="automatedCheckEnabled")
    public Boolean getAutomatedCheckEnabled() {
        return this.automatedCheckEnabled;
    }

    public void setAutomatedCheckEnabled(Boolean automatedCheckEnabled) {
        this.automatedCheckEnabled = automatedCheckEnabled;
    }

    public ChecklistItem important(Boolean important) {
        this.important = important;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to indicate whether this checklist item is marked as important.")
    @JsonProperty(value="important")
    public Boolean getImportant() {
        return this.important;
    }

    public void setImportant(Boolean important) {
        this.important = important;
    }

    public ChecklistItem stateFromModel(StateFromModelEnum stateFromModel) {
        this.stateFromModel = stateFromModel;
        return this;
    }

    @ApiModelProperty(example="null", value="Checklist state as evaluated by the model.")
    @JsonProperty(value="stateFromModel")
    public StateFromModelEnum getStateFromModel() {
        return this.stateFromModel;
    }

    public void setStateFromModel(StateFromModelEnum stateFromModel) {
        this.stateFromModel = stateFromModel;
    }

    public ChecklistItem stateFromAgent(StateFromAgentEnum stateFromAgent) {
        this.stateFromAgent = stateFromAgent;
        return this;
    }

    @ApiModelProperty(example="null", value="Checklist state as evaluated by the agent.")
    @JsonProperty(value="stateFromAgent")
    public StateFromAgentEnum getStateFromAgent() {
        return this.stateFromAgent;
    }

    public void setStateFromAgent(StateFromAgentEnum stateFromAgent) {
        this.stateFromAgent = stateFromAgent;
    }

    public ChecklistItem dateLastModifiedByModel(Date dateLastModifiedByModel) {
        this.dateLastModifiedByModel = dateLastModifiedByModel;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the checklist item was last modified by the model. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateLastModifiedByModel")
    public Date getDateLastModifiedByModel() {
        return this.dateLastModifiedByModel;
    }

    public void setDateLastModifiedByModel(Date dateLastModifiedByModel) {
        this.dateLastModifiedByModel = dateLastModifiedByModel;
    }

    public ChecklistItem dateLastModifiedByAgent(Date dateLastModifiedByAgent) {
        this.dateLastModifiedByAgent = dateLastModifiedByAgent;
        return this;
    }

    @ApiModelProperty(example="2025-08-06T03:52:10.150Z", value="Date when the checklist item was last modified by the agent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateLastModifiedByAgent")
    public Date getDateLastModifiedByAgent() {
        return this.dateLastModifiedByAgent;
    }

    public void setDateLastModifiedByAgent(Date dateLastModifiedByAgent) {
        this.dateLastModifiedByAgent = dateLastModifiedByAgent;
    }

    public ChecklistItem lastModifiedInAcw(Boolean lastModifiedInAcw) {
        this.lastModifiedInAcw = lastModifiedInAcw;
        return this;
    }

    @ApiModelProperty(example="null", value="Flag to indicate whether this checklist item was modified in ACW.")
    @JsonProperty(value="lastModifiedInAcw")
    public Boolean getLastModifiedInAcw() {
        return this.lastModifiedInAcw;
    }

    public void setLastModifiedInAcw(Boolean lastModifiedInAcw) {
        this.lastModifiedInAcw = lastModifiedInAcw;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChecklistItem checklistItem = (ChecklistItem)o;
        return Objects.equals(this.id, checklistItem.id) && Objects.equals(this.name, checklistItem.name) && Objects.equals(this.description, checklistItem.description) && Objects.equals(this.automatedCheckEnabled, checklistItem.automatedCheckEnabled) && Objects.equals(this.important, checklistItem.important) && Objects.equals((Object)this.stateFromModel, (Object)checklistItem.stateFromModel) && Objects.equals((Object)this.stateFromAgent, (Object)checklistItem.stateFromAgent) && Objects.equals(this.dateLastModifiedByModel, checklistItem.dateLastModifiedByModel) && Objects.equals(this.dateLastModifiedByAgent, checklistItem.dateLastModifiedByAgent) && Objects.equals(this.lastModifiedInAcw, checklistItem.lastModifiedInAcw) && Objects.equals(this.selfUri, checklistItem.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.automatedCheckEnabled, this.important, this.stateFromModel, this.stateFromAgent, this.dateLastModifiedByModel, this.dateLastModifiedByAgent, this.lastModifiedInAcw, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ChecklistItem {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    automatedCheckEnabled: ").append(this.toIndentedString(this.automatedCheckEnabled)).append("\n");
        sb.append("    important: ").append(this.toIndentedString(this.important)).append("\n");
        sb.append("    stateFromModel: ").append(this.toIndentedString((Object)this.stateFromModel)).append("\n");
        sb.append("    stateFromAgent: ").append(this.toIndentedString((Object)this.stateFromAgent)).append("\n");
        sb.append("    dateLastModifiedByModel: ").append(this.toIndentedString(this.dateLastModifiedByModel)).append("\n");
        sb.append("    dateLastModifiedByAgent: ").append(this.toIndentedString(this.dateLastModifiedByAgent)).append("\n");
        sb.append("    lastModifiedInAcw: ").append(this.toIndentedString(this.lastModifiedInAcw)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateFromModelEnumDeserializer.class)
    public static enum StateFromModelEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TICKED("Ticked"),
        UNTICKED("Unticked");

        private String value;

        private StateFromModelEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateFromModelEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateFromModelEnum value : StateFromModelEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateFromModelEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StateFromAgentEnumDeserializer.class)
    public static enum StateFromAgentEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TICKED("Ticked"),
        UNTICKED("Unticked");

        private String value;

        private StateFromAgentEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateFromAgentEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateFromAgentEnum value : StateFromAgentEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateFromAgentEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateFromAgentEnumDeserializer
    extends StdDeserializer<StateFromAgentEnum> {
        public StateFromAgentEnumDeserializer() {
            super(StateFromAgentEnumDeserializer.class);
        }

        public StateFromAgentEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateFromAgentEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class StateFromModelEnumDeserializer
    extends StdDeserializer<StateFromModelEnum> {
        public StateFromModelEnumDeserializer() {
            super(StateFromModelEnumDeserializer.class);
        }

        public StateFromModelEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateFromModelEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

