/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class AgentScheduleShiftActivity
implements Serializable {
    private ActivityCategoryEnum activityCategory = null;
    private Integer startOffsetMinutes = null;
    private Integer lengthMinutes = null;

    public AgentScheduleShiftActivity() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public AgentScheduleShiftActivity activityCategory(ActivityCategoryEnum activityCategory) {
        this.activityCategory = activityCategory;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The activity category for which the agent is scheduled")
    @JsonProperty(value="activityCategory")
    public ActivityCategoryEnum getActivityCategory() {
        return this.activityCategory;
    }

    public void setActivityCategory(ActivityCategoryEnum activityCategory) {
        this.activityCategory = activityCategory;
    }

    public AgentScheduleShiftActivity startOffsetMinutes(Integer startOffsetMinutes) {
        this.startOffsetMinutes = startOffsetMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The start offset of the activity, relative to referenceStartDate at the top level")
    @JsonProperty(value="startOffsetMinutes")
    public Integer getStartOffsetMinutes() {
        return this.startOffsetMinutes;
    }

    public void setStartOffsetMinutes(Integer startOffsetMinutes) {
        this.startOffsetMinutes = startOffsetMinutes;
    }

    public AgentScheduleShiftActivity lengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The length of the activity in minutes")
    @JsonProperty(value="lengthMinutes")
    public Integer getLengthMinutes() {
        return this.lengthMinutes;
    }

    public void setLengthMinutes(Integer lengthMinutes) {
        this.lengthMinutes = lengthMinutes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AgentScheduleShiftActivity agentScheduleShiftActivity = (AgentScheduleShiftActivity)o;
        return Objects.equals((Object)this.activityCategory, (Object)agentScheduleShiftActivity.activityCategory) && Objects.equals(this.startOffsetMinutes, agentScheduleShiftActivity.startOffsetMinutes) && Objects.equals(this.lengthMinutes, agentScheduleShiftActivity.lengthMinutes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activityCategory, this.startOffsetMinutes, this.lengthMinutes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AgentScheduleShiftActivity {\n");
        sb.append("    activityCategory: ").append(this.toIndentedString((Object)this.activityCategory)).append("\n");
        sb.append("    startOffsetMinutes: ").append(this.toIndentedString(this.startOffsetMinutes)).append("\n");
        sb.append("    lengthMinutes: ").append(this.toIndentedString(this.lengthMinutes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActivityCategoryEnumDeserializer.class)
    public static enum ActivityCategoryEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ONQUEUEWORK("OnQueueWork"),
        BREAK("Break"),
        MEAL("Meal"),
        MEETING("Meeting"),
        OFFQUEUEWORK("OffQueueWork"),
        TIMEOFF("TimeOff"),
        TRAINING("Training"),
        UNAVAILABLE("Unavailable");

        private String value;

        private ActivityCategoryEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivityCategoryEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivityCategoryEnum value : ActivityCategoryEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivityCategoryEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActivityCategoryEnumDeserializer
    extends StdDeserializer<ActivityCategoryEnum> {
        public ActivityCategoryEnumDeserializer() {
            super(ActivityCategoryEnumDeserializer.class);
        }

        public ActivityCategoryEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivityCategoryEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

