/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.AssistantQueueUsersJobsRequest;
import java.util.HashMap;
import java.util.Map;

public class PostAssistantQueueUsersJobsRequest {
    private String assistantId;
    private String queueId;
    private AssistantQueueUsersJobsRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAssistantId() {
        return this.assistantId;
    }

    public void setAssistantId(String assistantId) {
        this.assistantId = assistantId;
    }

    public PostAssistantQueueUsersJobsRequest withAssistantId(String assistantId) {
        this.setAssistantId(assistantId);
        return this;
    }

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PostAssistantQueueUsersJobsRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public AssistantQueueUsersJobsRequest getBody() {
        return this.body;
    }

    public void setBody(AssistantQueueUsersJobsRequest body) {
        this.body = body;
    }

    public PostAssistantQueueUsersJobsRequest withBody(AssistantQueueUsersJobsRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostAssistantQueueUsersJobsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<AssistantQueueUsersJobsRequest> withHttpInfo() {
        if (this.assistantId == null) {
            throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PostAssistantQueueUsersJobsRequest.");
        }
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostAssistantQueueUsersJobsRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAssistantQueueUsersJobsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/assistants/{assistantId}/queues/{queueId}/users/jobs").withPathParameter("assistantId", this.assistantId).withPathParameter("queueId", this.queueId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String assistantId, String queueId, AssistantQueueUsersJobsRequest body) {
        return new Builder().withRequiredParams(assistantId, queueId, body);
    }

    public static class Builder {
        private final PostAssistantQueueUsersJobsRequest request = new PostAssistantQueueUsersJobsRequest();

        private Builder() {
        }

        public Builder withAssistantId(String assistantId) {
            this.request.setAssistantId(assistantId);
            return this;
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withBody(AssistantQueueUsersJobsRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String assistantId, String queueId, AssistantQueueUsersJobsRequest body) {
            this.request.setAssistantId(assistantId);
            this.request.setQueueId(queueId);
            this.request.setBody(body);
            return this;
        }

        public PostAssistantQueueUsersJobsRequest build() {
            if (this.request.assistantId == null) {
                throw new IllegalStateException("Missing the required parameter 'assistantId' when building request for PostAssistantQueueUsersJobsRequest.");
            }
            if (this.request.queueId == null) {
                throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostAssistantQueueUsersJobsRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostAssistantQueueUsersJobsRequest.");
            }
            return this.request;
        }
    }
}

