/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.IntentsCategoryPatch;
import java.util.HashMap;
import java.util.Map;

public class PatchIntentsCategoryRequest {
    private String categoryId;
    private IntentsCategoryPatch body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public PatchIntentsCategoryRequest withCategoryId(String categoryId) {
        this.setCategoryId(categoryId);
        return this;
    }

    public IntentsCategoryPatch getBody() {
        return this.body;
    }

    public void setBody(IntentsCategoryPatch body) {
        this.body = body;
    }

    public PatchIntentsCategoryRequest withBody(IntentsCategoryPatch body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchIntentsCategoryRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<IntentsCategoryPatch> withHttpInfo() {
        if (this.categoryId == null) {
            throw new IllegalStateException("Missing the required parameter 'categoryId' when building request for PatchIntentsCategoryRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchIntentsCategoryRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/intents/categories/{categoryId}").withPathParameter("categoryId", this.categoryId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String categoryId, IntentsCategoryPatch body) {
        return new Builder().withRequiredParams(categoryId, body);
    }

    public static class Builder {
        private final PatchIntentsCategoryRequest request = new PatchIntentsCategoryRequest();

        private Builder() {
        }

        public Builder withCategoryId(String categoryId) {
            this.request.setCategoryId(categoryId);
            return this;
        }

        public Builder withBody(IntentsCategoryPatch body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String categoryId, IntentsCategoryPatch body) {
            this.request.setCategoryId(categoryId);
            this.request.setBody(body);
            return this;
        }

        public PatchIntentsCategoryRequest build() {
            if (this.request.categoryId == null) {
                throw new IllegalStateException("Missing the required parameter 'categoryId' when building request for PatchIntentsCategoryRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchIntentsCategoryRequest.");
            }
            return this.request;
        }
    }
}

