/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.GuideVersionResources;
import com.mypurecloud.sdk.v2.model.Variable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Request body for updating a guide version")
public class UpdateGuideVersion
implements Serializable {
    private String instruction = null;
    private List<Variable> variables = null;
    private GuideVersionResources resources = null;

    public UpdateGuideVersion() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.variables = new ArrayList<Variable>();
        }
    }

    public UpdateGuideVersion instruction(String instruction) {
        this.instruction = instruction;
        return this;
    }

    @ApiModelProperty(example="null", value="The instruction given to this version of the guide, for how it should behave when interacting with a User.")
    @JsonProperty(value="instruction")
    public String getInstruction() {
        return this.instruction;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public UpdateGuideVersion variables(List<Variable> variables) {
        this.variables = variables;
        return this;
    }

    @ApiModelProperty(example="null", value="The variables associated with this version of the guide. Includes input variables (provided) and output variables (captured during execution).")
    @JsonProperty(value="variables")
    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public UpdateGuideVersion resources(GuideVersionResources resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(example="null", value="The resources associated with this version of the guide.")
    @JsonProperty(value="resources")
    public GuideVersionResources getResources() {
        return this.resources;
    }

    public void setResources(GuideVersionResources resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateGuideVersion updateGuideVersion = (UpdateGuideVersion)o;
        return Objects.equals(this.instruction, updateGuideVersion.instruction) && Objects.equals(this.variables, updateGuideVersion.variables) && Objects.equals(this.resources, updateGuideVersion.resources);
    }

    public int hashCode() {
        return Objects.hash(this.instruction, this.variables, this.resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateGuideVersion {\n");
        sb.append("    instruction: ").append(this.toIndentedString(this.instruction)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

