/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.PredictorModelFeature;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class PredictorModel
implements Serializable {
    private String id = null;
    private String kpi = null;
    private List<AddressableEntityRef> queues = null;
    private Date dateCreated = null;
    private Date dateTrained = null;
    private MediaTypeEnum mediaType = null;
    private List<PredictorModelFeature> features = null;

    public PredictorModel() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.queues = new ArrayList<AddressableEntityRef>();
            this.features = new ArrayList<PredictorModelFeature>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="The key performance indicator used in the model.")
    @JsonProperty(value="kpi")
    public String getKpi() {
        return this.kpi;
    }

    @ApiModelProperty(example="null", value="The List of Queues that are assessed for Predictive Routing.")
    @JsonProperty(value="queues")
    public List<AddressableEntityRef> getQueues() {
        return this.queues;
    }

    @ApiModelProperty(example="null", value="DateTime indicating when the model was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="DateTime indicating when the model was last trained. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateTrained")
    public Date getDateTrained() {
        return this.dateTrained;
    }

    @ApiModelProperty(example="null", value="The media type of the model.")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public PredictorModel features(List<PredictorModelFeature> features) {
        this.features = features;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="features")
    public List<PredictorModelFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<PredictorModelFeature> features) {
        this.features = features;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PredictorModel predictorModel = (PredictorModel)o;
        return Objects.equals(this.id, predictorModel.id) && Objects.equals(this.kpi, predictorModel.kpi) && Objects.equals(this.queues, predictorModel.queues) && Objects.equals(this.dateCreated, predictorModel.dateCreated) && Objects.equals(this.dateTrained, predictorModel.dateTrained) && Objects.equals((Object)this.mediaType, (Object)predictorModel.mediaType) && Objects.equals(this.features, predictorModel.features);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.kpi, this.queues, this.dateCreated, this.dateTrained, this.mediaType, this.features});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PredictorModel {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    kpi: ").append(this.toIndentedString(this.kpi)).append("\n");
        sb.append("    queues: ").append(this.toIndentedString(this.queues)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateTrained: ").append(this.toIndentedString(this.dateTrained)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("voice"),
        EMAIL("email"),
        MESSAGE("message");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

