/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class KeyPerformanceIndicatorType
implements Serializable {
    private IdEnum id = null;
    private List<SourcesEnum> sources = null;

    public KeyPerformanceIndicatorType() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.sources = new ArrayList<SourcesEnum>();
        }
    }

    @ApiModelProperty(example="null", value="The id the Key Performance Indicator Type.")
    @JsonProperty(value="id")
    public IdEnum getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="A set of kpi sources where values for a Key Performance Indicator are retrieved from.")
    @JsonProperty(value="sources")
    public List<SourcesEnum> getSources() {
        return this.sources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyPerformanceIndicatorType keyPerformanceIndicatorType = (KeyPerformanceIndicatorType)o;
        return Objects.equals((Object)this.id, (Object)keyPerformanceIndicatorType.id) && Objects.equals(this.sources, keyPerformanceIndicatorType.sources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.sources});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeyPerformanceIndicatorType {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=IdEnumDeserializer.class)
    public static enum IdEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SALESCONVERSION("SalesConversion"),
        CHURN("Churn"),
        RETENTION("Retention"),
        SALESVALUE("SalesValue"),
        HANDLETIME("HandleTime"),
        NEXTCONTACTAVOIDANCE("NextContactAvoidance");

        private String value;

        private IdEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static IdEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (IdEnum value : IdEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return IdEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=SourcesEnumDeserializer.class)
    public static enum SourcesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WRAPUPCODE("WrapUpCode"),
        OUTCOME("Outcome"),
        NONE("None");

        private String value;

        private SourcesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SourcesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SourcesEnum value : SourcesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SourcesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SourcesEnumDeserializer
    extends StdDeserializer<SourcesEnum> {
        public SourcesEnumDeserializer() {
            super(SourcesEnumDeserializer.class);
        }

        public SourcesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SourcesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class IdEnumDeserializer
    extends StdDeserializer<IdEnum> {
        public IdEnumDeserializer() {
            super(IdEnumDeserializer.class);
        }

        public IdEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return IdEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

