/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CoachingScheduleSlotsJobRequest
implements Serializable {
    private List<String> attendeeIds = null;
    private List<String> facilitatorIds = null;
    private Integer lengthInMinutes = null;
    private String activityCodeId = null;
    private List<String> intervals = null;
    private SlotsTypeEnum slotsType = null;

    public CoachingScheduleSlotsJobRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.attendeeIds = new ArrayList<String>();
            this.facilitatorIds = new ArrayList<String>();
            this.intervals = new ArrayList<String>();
        }
    }

    public CoachingScheduleSlotsJobRequest attendeeIds(List<String> attendeeIds) {
        this.attendeeIds = attendeeIds;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The attendee IDs to fetch the slots for.")
    @JsonProperty(value="attendeeIds")
    public List<String> getAttendeeIds() {
        return this.attendeeIds;
    }

    public void setAttendeeIds(List<String> attendeeIds) {
        this.attendeeIds = attendeeIds;
    }

    public CoachingScheduleSlotsJobRequest facilitatorIds(List<String> facilitatorIds) {
        this.facilitatorIds = facilitatorIds;
        return this;
    }

    @ApiModelProperty(example="null", value="The facilitator IDs to fetch the slots for.")
    @JsonProperty(value="facilitatorIds")
    public List<String> getFacilitatorIds() {
        return this.facilitatorIds;
    }

    public void setFacilitatorIds(List<String> facilitatorIds) {
        this.facilitatorIds = facilitatorIds;
    }

    public CoachingScheduleSlotsJobRequest lengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The length in minutes of the slots, in 15 minutes granularity.")
    @JsonProperty(value="lengthInMinutes")
    public Integer getLengthInMinutes() {
        return this.lengthInMinutes;
    }

    public void setLengthInMinutes(Integer lengthInMinutes) {
        this.lengthInMinutes = lengthInMinutes;
    }

    public CoachingScheduleSlotsJobRequest activityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Activity Code Id of the slots.")
    @JsonProperty(value="activityCodeId")
    public String getActivityCodeId() {
        return this.activityCodeId;
    }

    public void setActivityCodeId(String activityCodeId) {
        this.activityCodeId = activityCodeId;
    }

    public CoachingScheduleSlotsJobRequest intervals(List<String> intervals) {
        this.intervals = intervals;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The intervals to fetch the slots for. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="intervals")
    public List<String> getIntervals() {
        return this.intervals;
    }

    public void setIntervals(List<String> intervals) {
        this.intervals = intervals;
    }

    public CoachingScheduleSlotsJobRequest slotsType(SlotsTypeEnum slotsType) {
        this.slotsType = slotsType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of slots to fetch in the job.")
    @JsonProperty(value="slotsType")
    public SlotsTypeEnum getSlotsType() {
        return this.slotsType;
    }

    public void setSlotsType(SlotsTypeEnum slotsType) {
        this.slotsType = slotsType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoachingScheduleSlotsJobRequest coachingScheduleSlotsJobRequest = (CoachingScheduleSlotsJobRequest)o;
        return Objects.equals(this.attendeeIds, coachingScheduleSlotsJobRequest.attendeeIds) && Objects.equals(this.facilitatorIds, coachingScheduleSlotsJobRequest.facilitatorIds) && Objects.equals(this.lengthInMinutes, coachingScheduleSlotsJobRequest.lengthInMinutes) && Objects.equals(this.activityCodeId, coachingScheduleSlotsJobRequest.activityCodeId) && Objects.equals(this.intervals, coachingScheduleSlotsJobRequest.intervals) && Objects.equals((Object)this.slotsType, (Object)coachingScheduleSlotsJobRequest.slotsType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attendeeIds, this.facilitatorIds, this.lengthInMinutes, this.activityCodeId, this.intervals, this.slotsType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CoachingScheduleSlotsJobRequest {\n");
        sb.append("    attendeeIds: ").append(this.toIndentedString(this.attendeeIds)).append("\n");
        sb.append("    facilitatorIds: ").append(this.toIndentedString(this.facilitatorIds)).append("\n");
        sb.append("    lengthInMinutes: ").append(this.toIndentedString(this.lengthInMinutes)).append("\n");
        sb.append("    activityCodeId: ").append(this.toIndentedString(this.activityCodeId)).append("\n");
        sb.append("    intervals: ").append(this.toIndentedString(this.intervals)).append("\n");
        sb.append("    slotsType: ").append(this.toIndentedString((Object)this.slotsType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SlotsTypeEnumDeserializer.class)
    public static enum SlotsTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BESTTIME("BestTime");

        private String value;

        private SlotsTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SlotsTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SlotsTypeEnum value : SlotsTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SlotsTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SlotsTypeEnumDeserializer
    extends StdDeserializer<SlotsTypeEnum> {
        public SlotsTypeEnumDeserializer() {
            super(SlotsTypeEnumDeserializer.class);
        }

        public SlotsTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SlotsTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

