/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApplePay
implements Serializable {
    private String storeName = null;
    private String merchantId = null;
    private String domainName = null;
    private List<PaymentCapabilitiesEnum> paymentCapabilities = null;
    private List<SupportedPaymentNetworksEnum> supportedPaymentNetworks = null;
    private String paymentCertificateCredentialId = null;
    private String paymentGatewayUrl = null;
    private String fallbackUrl = null;
    private String shippingMethodUpdateUrl = null;
    private String shippingContactUpdateUrl = null;
    private String paymentMethodUpdateUrl = null;
    private String orderTrackingUrl = null;

    public ApplePay() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.paymentCapabilities = new ArrayList<PaymentCapabilitiesEnum>();
            this.supportedPaymentNetworks = new ArrayList<SupportedPaymentNetworksEnum>();
        }
    }

    public ApplePay storeName(String storeName) {
        this.storeName = storeName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the store.")
    @JsonProperty(value="storeName")
    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public ApplePay merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The stores merchant identifier.")
    @JsonProperty(value="merchantId")
    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public ApplePay domainName(String domainName) {
        this.domainName = domainName;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The domain name associated with the merchant account.")
    @JsonProperty(value="domainName")
    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public ApplePay paymentCapabilities(List<PaymentCapabilitiesEnum> paymentCapabilities) {
        this.paymentCapabilities = paymentCapabilities;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The payment capabilities supported by the merchant.")
    @JsonProperty(value="paymentCapabilities")
    public List<PaymentCapabilitiesEnum> getPaymentCapabilities() {
        return this.paymentCapabilities;
    }

    public void setPaymentCapabilities(List<PaymentCapabilitiesEnum> paymentCapabilities) {
        this.paymentCapabilities = paymentCapabilities;
    }

    public ApplePay supportedPaymentNetworks(List<SupportedPaymentNetworksEnum> supportedPaymentNetworks) {
        this.supportedPaymentNetworks = supportedPaymentNetworks;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The payment networks supported by the merchant.")
    @JsonProperty(value="supportedPaymentNetworks")
    public List<SupportedPaymentNetworksEnum> getSupportedPaymentNetworks() {
        return this.supportedPaymentNetworks;
    }

    public void setSupportedPaymentNetworks(List<SupportedPaymentNetworksEnum> supportedPaymentNetworks) {
        this.supportedPaymentNetworks = supportedPaymentNetworks;
    }

    public ApplePay paymentCertificateCredentialId(String paymentCertificateCredentialId) {
        this.paymentCertificateCredentialId = paymentCertificateCredentialId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The Genesys credentialId the payment certificates are stored under.")
    @JsonProperty(value="paymentCertificateCredentialId")
    public String getPaymentCertificateCredentialId() {
        return this.paymentCertificateCredentialId;
    }

    public void setPaymentCertificateCredentialId(String paymentCertificateCredentialId) {
        this.paymentCertificateCredentialId = paymentCertificateCredentialId;
    }

    public ApplePay paymentGatewayUrl(String paymentGatewayUrl) {
        this.paymentGatewayUrl = paymentGatewayUrl;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The url used to process payments.")
    @JsonProperty(value="paymentGatewayUrl")
    public String getPaymentGatewayUrl() {
        return this.paymentGatewayUrl;
    }

    public void setPaymentGatewayUrl(String paymentGatewayUrl) {
        this.paymentGatewayUrl = paymentGatewayUrl;
    }

    public ApplePay fallbackUrl(String fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url opened in a web browser if the customers device is unable to make payments using Apple Pay.")
    @JsonProperty(value="fallbackUrl")
    public String getFallbackUrl() {
        return this.fallbackUrl;
    }

    public void setFallbackUrl(String fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
    }

    public ApplePay shippingMethodUpdateUrl(String shippingMethodUpdateUrl) {
        this.shippingMethodUpdateUrl = shippingMethodUpdateUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url called when the customer changes the shipping method.")
    @JsonProperty(value="shippingMethodUpdateUrl")
    public String getShippingMethodUpdateUrl() {
        return this.shippingMethodUpdateUrl;
    }

    public void setShippingMethodUpdateUrl(String shippingMethodUpdateUrl) {
        this.shippingMethodUpdateUrl = shippingMethodUpdateUrl;
    }

    public ApplePay shippingContactUpdateUrl(String shippingContactUpdateUrl) {
        this.shippingContactUpdateUrl = shippingContactUpdateUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url called when the customer changes their shipping address information.")
    @JsonProperty(value="shippingContactUpdateUrl")
    public String getShippingContactUpdateUrl() {
        return this.shippingContactUpdateUrl;
    }

    public void setShippingContactUpdateUrl(String shippingContactUpdateUrl) {
        this.shippingContactUpdateUrl = shippingContactUpdateUrl;
    }

    public ApplePay paymentMethodUpdateUrl(String paymentMethodUpdateUrl) {
        this.paymentMethodUpdateUrl = paymentMethodUpdateUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url called when the customer changes their payment method.")
    @JsonProperty(value="paymentMethodUpdateUrl")
    public String getPaymentMethodUpdateUrl() {
        return this.paymentMethodUpdateUrl;
    }

    public void setPaymentMethodUpdateUrl(String paymentMethodUpdateUrl) {
        this.paymentMethodUpdateUrl = paymentMethodUpdateUrl;
    }

    public ApplePay orderTrackingUrl(String orderTrackingUrl) {
        this.orderTrackingUrl = orderTrackingUrl;
        return this;
    }

    @ApiModelProperty(example="null", value="The url called after completing the order to update the order information in your system")
    @JsonProperty(value="orderTrackingUrl")
    public String getOrderTrackingUrl() {
        return this.orderTrackingUrl;
    }

    public void setOrderTrackingUrl(String orderTrackingUrl) {
        this.orderTrackingUrl = orderTrackingUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplePay applePay = (ApplePay)o;
        return Objects.equals(this.storeName, applePay.storeName) && Objects.equals(this.merchantId, applePay.merchantId) && Objects.equals(this.domainName, applePay.domainName) && Objects.equals(this.paymentCapabilities, applePay.paymentCapabilities) && Objects.equals(this.supportedPaymentNetworks, applePay.supportedPaymentNetworks) && Objects.equals(this.paymentCertificateCredentialId, applePay.paymentCertificateCredentialId) && Objects.equals(this.paymentGatewayUrl, applePay.paymentGatewayUrl) && Objects.equals(this.fallbackUrl, applePay.fallbackUrl) && Objects.equals(this.shippingMethodUpdateUrl, applePay.shippingMethodUpdateUrl) && Objects.equals(this.shippingContactUpdateUrl, applePay.shippingContactUpdateUrl) && Objects.equals(this.paymentMethodUpdateUrl, applePay.paymentMethodUpdateUrl) && Objects.equals(this.orderTrackingUrl, applePay.orderTrackingUrl);
    }

    public int hashCode() {
        return Objects.hash(this.storeName, this.merchantId, this.domainName, this.paymentCapabilities, this.supportedPaymentNetworks, this.paymentCertificateCredentialId, this.paymentGatewayUrl, this.fallbackUrl, this.shippingMethodUpdateUrl, this.shippingContactUpdateUrl, this.paymentMethodUpdateUrl, this.orderTrackingUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplePay {\n");
        sb.append("    storeName: ").append(this.toIndentedString(this.storeName)).append("\n");
        sb.append("    merchantId: ").append(this.toIndentedString(this.merchantId)).append("\n");
        sb.append("    domainName: ").append(this.toIndentedString(this.domainName)).append("\n");
        sb.append("    paymentCapabilities: ").append(this.toIndentedString(this.paymentCapabilities)).append("\n");
        sb.append("    supportedPaymentNetworks: ").append(this.toIndentedString(this.supportedPaymentNetworks)).append("\n");
        sb.append("    paymentCertificateCredentialId: ").append(this.toIndentedString(this.paymentCertificateCredentialId)).append("\n");
        sb.append("    paymentGatewayUrl: ").append(this.toIndentedString(this.paymentGatewayUrl)).append("\n");
        sb.append("    fallbackUrl: ").append(this.toIndentedString(this.fallbackUrl)).append("\n");
        sb.append("    shippingMethodUpdateUrl: ").append(this.toIndentedString(this.shippingMethodUpdateUrl)).append("\n");
        sb.append("    shippingContactUpdateUrl: ").append(this.toIndentedString(this.shippingContactUpdateUrl)).append("\n");
        sb.append("    paymentMethodUpdateUrl: ").append(this.toIndentedString(this.paymentMethodUpdateUrl)).append("\n");
        sb.append("    orderTrackingUrl: ").append(this.toIndentedString(this.orderTrackingUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SupportedPaymentNetworksEnumDeserializer.class)
    public static enum SupportedPaymentNetworksEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AMEX("amex"),
        DISCOVER("discover"),
        JCB("jcb"),
        MASTERCARD("masterCard"),
        PRIVATELABEL("privateLabel"),
        VISA("visa");

        private String value;

        private SupportedPaymentNetworksEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SupportedPaymentNetworksEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SupportedPaymentNetworksEnum value : SupportedPaymentNetworksEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SupportedPaymentNetworksEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SupportedPaymentNetworksEnumDeserializer
    extends StdDeserializer<SupportedPaymentNetworksEnum> {
        public SupportedPaymentNetworksEnumDeserializer() {
            super(SupportedPaymentNetworksEnumDeserializer.class);
        }

        public SupportedPaymentNetworksEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SupportedPaymentNetworksEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=PaymentCapabilitiesEnumDeserializer.class)
    public static enum PaymentCapabilitiesEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        _3DS("3DS"),
        CREDITCARD("creditCard"),
        DEBITCARD("debitCard");

        private String value;

        private PaymentCapabilitiesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PaymentCapabilitiesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PaymentCapabilitiesEnum value : PaymentCapabilitiesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PaymentCapabilitiesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PaymentCapabilitiesEnumDeserializer
    extends StdDeserializer<PaymentCapabilitiesEnum> {
        public PaymentCapabilitiesEnumDeserializer() {
            super(PaymentCapabilitiesEnumDeserializer.class);
        }

        public PaymentCapabilitiesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PaymentCapabilitiesEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

