/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CreateGuideVersion;
import java.util.HashMap;
import java.util.Map;

public class PostGuideVersionsRequest {
    private String guideId;
    private CreateGuideVersion body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGuideId() {
        return this.guideId;
    }

    public void setGuideId(String guideId) {
        this.guideId = guideId;
    }

    public PostGuideVersionsRequest withGuideId(String guideId) {
        this.setGuideId(guideId);
        return this;
    }

    public CreateGuideVersion getBody() {
        return this.body;
    }

    public void setBody(CreateGuideVersion body) {
        this.body = body;
    }

    public PostGuideVersionsRequest withBody(CreateGuideVersion body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostGuideVersionsRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CreateGuideVersion> withHttpInfo() {
        if (this.guideId == null) {
            throw new IllegalStateException("Missing the required parameter 'guideId' when building request for PostGuideVersionsRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/guides/{guideId}/versions").withPathParameter("guideId", this.guideId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String guideId) {
        return new Builder().withRequiredParams(guideId);
    }

    public static class Builder {
        private final PostGuideVersionsRequest request = new PostGuideVersionsRequest();

        private Builder() {
        }

        public Builder withGuideId(String guideId) {
            this.request.setGuideId(guideId);
            return this;
        }

        public Builder withBody(CreateGuideVersion body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String guideId) {
            this.request.setGuideId(guideId);
            return this;
        }

        public PostGuideVersionsRequest build() {
            if (this.request.guideId == null) {
                throw new IllegalStateException("Missing the required parameter 'guideId' when building request for PostGuideVersionsRequest.");
            }
            return this.request;
        }
    }
}

