/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TranscriptsFilters
implements Serializable {
    private MediaTypeEnum mediaType = null;
    private Long startTimeMs = null;
    private Long endTimeMs = null;
    private List<String> queues = null;
    private List<String> flows = null;

    public TranscriptsFilters() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.queues = new ArrayList<String>();
            this.flows = new ArrayList<String>();
        }
    }

    public TranscriptsFilters mediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    @ApiModelProperty(example="null", value="The media type of the transcripts, default value is all ")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaTypeEnum mediaType) {
        this.mediaType = mediaType;
    }

    public TranscriptsFilters startTimeMs(Long startTimeMs) {
        this.startTimeMs = startTimeMs;
        return this;
    }

    @ApiModelProperty(example="null", value="start time to filter by, default value is 7 days into the past")
    @JsonProperty(value="startTimeMs")
    public Long getStartTimeMs() {
        return this.startTimeMs;
    }

    public void setStartTimeMs(Long startTimeMs) {
        this.startTimeMs = startTimeMs;
    }

    public TranscriptsFilters endTimeMs(Long endTimeMs) {
        this.endTimeMs = endTimeMs;
        return this;
    }

    @ApiModelProperty(example="null", value="end time to filter by, default value is current time")
    @JsonProperty(value="endTimeMs")
    public Long getEndTimeMs() {
        return this.endTimeMs;
    }

    public void setEndTimeMs(Long endTimeMs) {
        this.endTimeMs = endTimeMs;
    }

    public TranscriptsFilters queues(List<String> queues) {
        this.queues = queues;
        return this;
    }

    @ApiModelProperty(example="null", value="list of queues ids to filter by")
    @JsonProperty(value="queues")
    public List<String> getQueues() {
        return this.queues;
    }

    public void setQueues(List<String> queues) {
        this.queues = queues;
    }

    public TranscriptsFilters flows(List<String> flows) {
        this.flows = flows;
        return this;
    }

    @ApiModelProperty(example="null", value="list of flows ids to filter by")
    @JsonProperty(value="flows")
    public List<String> getFlows() {
        return this.flows;
    }

    public void setFlows(List<String> flows) {
        this.flows = flows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranscriptsFilters transcriptsFilters = (TranscriptsFilters)o;
        return Objects.equals((Object)this.mediaType, (Object)transcriptsFilters.mediaType) && Objects.equals(this.startTimeMs, transcriptsFilters.startTimeMs) && Objects.equals(this.endTimeMs, transcriptsFilters.endTimeMs) && Objects.equals(this.queues, transcriptsFilters.queues) && Objects.equals(this.flows, transcriptsFilters.flows);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mediaType, this.startTimeMs, this.endTimeMs, this.queues, this.flows});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TranscriptsFilters {\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("    startTimeMs: ").append(this.toIndentedString(this.startTimeMs)).append("\n");
        sb.append("    endTimeMs: ").append(this.toIndentedString(this.endTimeMs)).append("\n");
        sb.append("    queues: ").append(this.toIndentedString(this.queues)).append("\n");
        sb.append("    flows: ").append(this.toIndentedString(this.flows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CALL("call"),
        MESSAGE("message"),
        EMAIL("email"),
        CHAT("chat"),
        CALLBACK("callback"),
        ALL("all");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

