/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.PatchCriteria;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PatchJourneyPattern
implements Serializable {
    private List<PatchCriteria> criteria = null;
    private Integer count = null;
    private StreamTypeEnum streamType = null;
    private String sessionType = null;
    private String eventName = null;

    public PatchJourneyPattern() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.criteria = new ArrayList<PatchCriteria>();
        }
    }

    public PatchJourneyPattern criteria(List<PatchCriteria> criteria) {
        this.criteria = criteria;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of one or more criteria to satisfy.")
    @JsonProperty(value="criteria")
    public List<PatchCriteria> getCriteria() {
        return this.criteria;
    }

    public void setCriteria(List<PatchCriteria> criteria) {
        this.criteria = criteria;
    }

    public PatchJourneyPattern count(Integer count) {
        this.count = count;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of times the pattern must match.")
    @JsonProperty(value="count")
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public PatchJourneyPattern streamType(StreamTypeEnum streamType) {
        this.streamType = streamType;
        return this;
    }

    @ApiModelProperty(example="null", value="The stream type for which this pattern can be matched on.")
    @JsonProperty(value="streamType")
    public StreamTypeEnum getStreamType() {
        return this.streamType;
    }

    public void setStreamType(StreamTypeEnum streamType) {
        this.streamType = streamType;
    }

    public PatchJourneyPattern sessionType(String sessionType) {
        this.sessionType = sessionType;
        return this;
    }

    @ApiModelProperty(example="null", value="The session type for which this pattern can be matched on.")
    @JsonProperty(value="sessionType")
    public String getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(String sessionType) {
        this.sessionType = sessionType;
    }

    public PatchJourneyPattern eventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    @ApiModelProperty(example="null", value="The name of the event for which this pattern can be matched on.")
    @JsonProperty(value="eventName")
    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatchJourneyPattern patchJourneyPattern = (PatchJourneyPattern)o;
        return Objects.equals(this.criteria, patchJourneyPattern.criteria) && Objects.equals(this.count, patchJourneyPattern.count) && Objects.equals((Object)this.streamType, (Object)patchJourneyPattern.streamType) && Objects.equals(this.sessionType, patchJourneyPattern.sessionType) && Objects.equals(this.eventName, patchJourneyPattern.eventName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.criteria, this.count, this.streamType, this.sessionType, this.eventName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PatchJourneyPattern {\n");
        sb.append("    criteria: ").append(this.toIndentedString(this.criteria)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    streamType: ").append(this.toIndentedString((Object)this.streamType)).append("\n");
        sb.append("    sessionType: ").append(this.toIndentedString(this.sessionType)).append("\n");
        sb.append("    eventName: ").append(this.toIndentedString(this.eventName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StreamTypeEnumDeserializer.class)
    public static enum StreamTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        WEB("Web"),
        CUSTOM("Custom"),
        CONVERSATION("Conversation"),
        APP("App");

        private String value;

        private StreamTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StreamTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StreamTypeEnum value : StreamTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StreamTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StreamTypeEnumDeserializer
    extends StdDeserializer<StreamTypeEnum> {
        public StreamTypeEnumDeserializer() {
            super(StreamTypeEnumDeserializer.class);
        }

        public StreamTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StreamTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

