/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.OpenSocialMediaChannel;
import com.mypurecloud.sdk.v2.model.OpenSocialMediaMessageContent;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Open Social Messaging rich media message structure")
public class OpenSocialMediaNormalizedMessage
implements Serializable {
    private String id = null;
    private OpenSocialMediaChannel channel = null;
    private String text = null;
    private TypeEnum type = null;
    private List<OpenSocialMediaMessageContent> content = null;
    private Map<String, String> metadata = null;
    private String selfUri = null;

    public OpenSocialMediaNormalizedMessage() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.content = new ArrayList<OpenSocialMediaMessageContent>();
        }
    }

    @ApiModelProperty(example="null", value="Unique ID of the message generated by Genesys Platform.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OpenSocialMediaNormalizedMessage channel(OpenSocialMediaChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public OpenSocialMediaChannel getChannel() {
        return this.channel;
    }

    public void setChannel(OpenSocialMediaChannel channel) {
        this.channel = channel;
    }

    public OpenSocialMediaNormalizedMessage text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Message text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @ApiModelProperty(example="null", value="Message type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public OpenSocialMediaNormalizedMessage content(List<OpenSocialMediaMessageContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="List of content elements.")
    @JsonProperty(value="content")
    public List<OpenSocialMediaMessageContent> getContent() {
        return this.content;
    }

    public void setContent(List<OpenSocialMediaMessageContent> content) {
        this.content = content;
    }

    public OpenSocialMediaNormalizedMessage metadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional metadata about this message.")
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenSocialMediaNormalizedMessage openSocialMediaNormalizedMessage = (OpenSocialMediaNormalizedMessage)o;
        return Objects.equals(this.id, openSocialMediaNormalizedMessage.id) && Objects.equals(this.channel, openSocialMediaNormalizedMessage.channel) && Objects.equals(this.text, openSocialMediaNormalizedMessage.text) && Objects.equals((Object)this.type, (Object)openSocialMediaNormalizedMessage.type) && Objects.equals(this.content, openSocialMediaNormalizedMessage.content) && Objects.equals(this.metadata, openSocialMediaNormalizedMessage.metadata) && Objects.equals(this.selfUri, openSocialMediaNormalizedMessage.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.channel, this.text, this.type, this.content, this.metadata, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenSocialMediaNormalizedMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

