/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.MessagingSettingRequestReference;
import com.mypurecloud.sdk.v2.model.SupportedContentReference;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class FacebookIntegrationRequest
implements Serializable {
    private String id = null;
    private String name = null;
    private SupportedContentReference supportedContent = null;
    private MessagingSettingRequestReference messagingSetting = null;
    private String pageAccessToken = null;
    private String userAccessToken = null;
    private String pageId = null;
    private String appId = null;
    private String appSecret = null;
    private String selfUri = null;

    public FacebookIntegrationRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public FacebookIntegrationRequest name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the Facebook Integration")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FacebookIntegrationRequest supportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the SupportedContent profile configured for an integration")
    @JsonProperty(value="supportedContent")
    public SupportedContentReference getSupportedContent() {
        return this.supportedContent;
    }

    public void setSupportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
    }

    public FacebookIntegrationRequest messagingSetting(MessagingSettingRequestReference messagingSetting) {
        this.messagingSetting = messagingSetting;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the message settings to be applied for this integration")
    @JsonProperty(value="messagingSetting")
    public MessagingSettingRequestReference getMessagingSetting() {
        return this.messagingSetting;
    }

    public void setMessagingSetting(MessagingSettingRequestReference messagingSetting) {
        this.messagingSetting = messagingSetting;
    }

    public FacebookIntegrationRequest pageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
        return this;
    }

    @ApiModelProperty(example="null", value="The long-lived Page Access Token of Facebook page.  See https://developers.facebook.com/docs/facebook-login/access-tokens.  When a pageAccessToken is provided, pageId and userAccessToken are not required.")
    @JsonProperty(value="pageAccessToken")
    public String getPageAccessToken() {
        return this.pageAccessToken;
    }

    public void setPageAccessToken(String pageAccessToken) {
        this.pageAccessToken = pageAccessToken;
    }

    public FacebookIntegrationRequest userAccessToken(String userAccessToken) {
        this.userAccessToken = userAccessToken;
        return this;
    }

    @ApiModelProperty(example="null", value="The short-lived User Access Token of the Facebook user logged into the Facebook app.  See https://developers.facebook.com/docs/facebook-login/access-tokens.  When userAccessToken is provided, pageId is mandatory.  When userAccessToken/pageId combination is provided, pageAccessToken is not required.")
    @JsonProperty(value="userAccessToken")
    public String getUserAccessToken() {
        return this.userAccessToken;
    }

    public void setUserAccessToken(String userAccessToken) {
        this.userAccessToken = userAccessToken;
    }

    public FacebookIntegrationRequest pageId(String pageId) {
        this.pageId = pageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The page Id of Facebook page. The pageId is required when userAccessToken is provided.")
    @JsonProperty(value="pageId")
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public FacebookIntegrationRequest appId(String appId) {
        this.appId = appId;
        return this;
    }

    @ApiModelProperty(example="null", value="The app Id of Facebook app. The appId is required when a customer wants to use their own approved Facebook app.")
    @JsonProperty(value="appId")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public FacebookIntegrationRequest appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    @ApiModelProperty(example="null", value="The app Secret of Facebook app. The appSecret is required when appId is provided.")
    @JsonProperty(value="appSecret")
    public String getAppSecret() {
        return this.appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FacebookIntegrationRequest facebookIntegrationRequest = (FacebookIntegrationRequest)o;
        return Objects.equals(this.id, facebookIntegrationRequest.id) && Objects.equals(this.name, facebookIntegrationRequest.name) && Objects.equals(this.supportedContent, facebookIntegrationRequest.supportedContent) && Objects.equals(this.messagingSetting, facebookIntegrationRequest.messagingSetting) && Objects.equals(this.pageAccessToken, facebookIntegrationRequest.pageAccessToken) && Objects.equals(this.userAccessToken, facebookIntegrationRequest.userAccessToken) && Objects.equals(this.pageId, facebookIntegrationRequest.pageId) && Objects.equals(this.appId, facebookIntegrationRequest.appId) && Objects.equals(this.appSecret, facebookIntegrationRequest.appSecret) && Objects.equals(this.selfUri, facebookIntegrationRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.supportedContent, this.messagingSetting, this.pageAccessToken, this.userAccessToken, this.pageId, this.appId, this.appSecret, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FacebookIntegrationRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    supportedContent: ").append(this.toIndentedString(this.supportedContent)).append("\n");
        sb.append("    messagingSetting: ").append(this.toIndentedString(this.messagingSetting)).append("\n");
        sb.append("    pageAccessToken: ").append(this.toIndentedString(this.pageAccessToken)).append("\n");
        sb.append("    userAccessToken: ").append(this.toIndentedString(this.userAccessToken)).append("\n");
        sb.append("    pageId: ").append(this.toIndentedString(this.pageId)).append("\n");
        sb.append("    appId: ").append(this.toIndentedString(this.appId)).append("\n");
        sb.append("    appSecret: ").append(this.toIndentedString(this.appSecret)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

