/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ActionEventRequest
implements Serializable {
    private String id = null;
    private String sessionId = null;
    private String actionId = null;
    private ActionStateEnum actionState = null;
    private String errorCode = null;
    private String errorMessage = null;
    private String selfUri = null;

    public ActionEventRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ActionEventRequest sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="UUID of the customer session for this action.")
    @JsonProperty(value="sessionId")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public ActionEventRequest actionId(String actionId) {
        this.actionId = actionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="UUID for the action, as returned by the Ping endpoint when the action was qualified.")
    @JsonProperty(value="actionId")
    public String getActionId() {
        return this.actionId;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public ActionEventRequest actionState(ActionStateEnum actionState) {
        this.actionState = actionState;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="State the action is transitioning to.")
    @JsonProperty(value="actionState")
    public ActionStateEnum getActionState() {
        return this.actionState;
    }

    public void setActionState(ActionStateEnum actionState) {
        this.actionState = actionState;
    }

    public ActionEventRequest errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @ApiModelProperty(example="null", value="Client defined error code (when state transitions to errored)")
    @JsonProperty(value="errorCode")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public ActionEventRequest errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="Message of the error returned when the action fails (when state transitions to errored)")
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionEventRequest actionEventRequest = (ActionEventRequest)o;
        return Objects.equals(this.id, actionEventRequest.id) && Objects.equals(this.sessionId, actionEventRequest.sessionId) && Objects.equals(this.actionId, actionEventRequest.actionId) && Objects.equals((Object)this.actionState, (Object)actionEventRequest.actionState) && Objects.equals(this.errorCode, actionEventRequest.errorCode) && Objects.equals(this.errorMessage, actionEventRequest.errorMessage) && Objects.equals(this.selfUri, actionEventRequest.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.sessionId, this.actionId, this.actionState, this.errorCode, this.errorMessage, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionEventRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    actionId: ").append(this.toIndentedString(this.actionId)).append("\n");
        sb.append("    actionState: ").append(this.toIndentedString((Object)this.actionState)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionStateEnumDeserializer.class)
    public static enum ActionStateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        TIMEDOUT("timedout"),
        ERRORED("errored"),
        IGNORED("ignored"),
        QUALIFIED("qualified"),
        OFFERED("offered"),
        STARTED("started"),
        ENGAGED("engaged"),
        QUALIFIEDOUTSIDESCHEDULE("qualifiedOutsideSchedule"),
        OFFEREDOUTSIDESCHEDULE("offeredOutsideSchedule"),
        ABANDONED("abandoned"),
        COMPLETED("completed"),
        FREQUENCYCAPREACHED("frequencyCapReached");

        private String value;

        private ActionStateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionStateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionStateEnum value : ActionStateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionStateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionStateEnumDeserializer
    extends StdDeserializer<ActionStateEnum> {
        public ActionStateEnumDeserializer() {
            super(ActionStateEnumDeserializer.class);
        }

        public ActionStateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionStateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

