/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class PostChatsRoomParticipantRequest {
    private String roomJid;
    private String userId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoomJid() {
        return this.roomJid;
    }

    public void setRoomJid(String roomJid) {
        this.roomJid = roomJid;
    }

    public PostChatsRoomParticipantRequest withRoomJid(String roomJid) {
        this.setRoomJid(roomJid);
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PostChatsRoomParticipantRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostChatsRoomParticipantRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.roomJid == null) {
            throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PostChatsRoomParticipantRequest.");
        }
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostChatsRoomParticipantRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/chats/rooms/{roomJid}/participants/{userId}").withPathParameter("roomJid", this.roomJid).withPathParameter("userId", this.userId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roomJid, String userId) {
        return new Builder().withRequiredParams(roomJid, userId);
    }

    public static class Builder {
        private final PostChatsRoomParticipantRequest request = new PostChatsRoomParticipantRequest();

        private Builder() {
        }

        public Builder withRoomJid(String roomJid) {
            this.request.setRoomJid(roomJid);
            return this;
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withRequiredParams(String roomJid, String userId) {
            this.request.setRoomJid(roomJid);
            this.request.setUserId(userId);
            return this;
        }

        public PostChatsRoomParticipantRequest build() {
            if (this.request.roomJid == null) {
                throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PostChatsRoomParticipantRequest.");
            }
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PostChatsRoomParticipantRequest.");
            }
            return this.request;
        }
    }
}

