/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AssessmentForm;
import com.mypurecloud.sdk.v2.model.LearningAssessment;
import com.mypurecloud.sdk.v2.model.LearningModulePreviewUpdateRequestCurrentStep;
import com.mypurecloud.sdk.v2.model.LearningModulePreviewUpdateStep;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Learning module preview update request")
public class LearningModulePreviewUpdateRequest
implements Serializable {
    private StateEnum state = null;
    private LearningModulePreviewUpdateRequestCurrentStep currentStep = null;
    private List<LearningModulePreviewUpdateStep> steps = null;
    private LearningAssessment assessment = null;
    private AssessmentForm assessmentForm = null;

    public LearningModulePreviewUpdateRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.steps = new ArrayList<LearningModulePreviewUpdateStep>();
        }
    }

    public LearningModulePreviewUpdateRequest state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="The assignment State")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public LearningModulePreviewUpdateRequest currentStep(LearningModulePreviewUpdateRequestCurrentStep currentStep) {
        this.currentStep = currentStep;
        return this;
    }

    @ApiModelProperty(example="null", value="The assignment current step")
    @JsonProperty(value="currentStep")
    public LearningModulePreviewUpdateRequestCurrentStep getCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(LearningModulePreviewUpdateRequestCurrentStep currentStep) {
        this.currentStep = currentStep;
    }

    public LearningModulePreviewUpdateRequest steps(List<LearningModulePreviewUpdateStep> steps) {
        this.steps = steps;
        return this;
    }

    @ApiModelProperty(example="null", value="The assignment Steps")
    @JsonProperty(value="steps")
    public List<LearningModulePreviewUpdateStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<LearningModulePreviewUpdateStep> steps) {
        this.steps = steps;
    }

    public LearningModulePreviewUpdateRequest assessment(LearningAssessment assessment) {
        this.assessment = assessment;
        return this;
    }

    @ApiModelProperty(example="null", value="The assessment for learning module")
    @JsonProperty(value="assessment")
    public LearningAssessment getAssessment() {
        return this.assessment;
    }

    public void setAssessment(LearningAssessment assessment) {
        this.assessment = assessment;
    }

    public LearningModulePreviewUpdateRequest assessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
        return this;
    }

    @ApiModelProperty(example="null", value="The assessment form for learning module")
    @JsonProperty(value="assessmentForm")
    public AssessmentForm getAssessmentForm() {
        return this.assessmentForm;
    }

    public void setAssessmentForm(AssessmentForm assessmentForm) {
        this.assessmentForm = assessmentForm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningModulePreviewUpdateRequest learningModulePreviewUpdateRequest = (LearningModulePreviewUpdateRequest)o;
        return Objects.equals((Object)this.state, (Object)learningModulePreviewUpdateRequest.state) && Objects.equals(this.currentStep, learningModulePreviewUpdateRequest.currentStep) && Objects.equals(this.steps, learningModulePreviewUpdateRequest.steps) && Objects.equals(this.assessment, learningModulePreviewUpdateRequest.assessment) && Objects.equals(this.assessmentForm, learningModulePreviewUpdateRequest.assessmentForm);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.currentStep, this.steps, this.assessment, this.assessmentForm});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LearningModulePreviewUpdateRequest {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    currentStep: ").append(this.toIndentedString(this.currentStep)).append("\n");
        sb.append("    steps: ").append(this.toIndentedString(this.steps)).append("\n");
        sb.append("    assessment: ").append(this.toIndentedString(this.assessment)).append("\n");
        sb.append("    assessmentForm: ").append(this.toIndentedString(this.assessmentForm)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ASSIGNED("Assigned"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        DELETED("Deleted"),
        NOTCOMPLETED("NotCompleted"),
        INVALIDSCHEDULE("InvalidSchedule");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

