/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ContactIdentifier;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class IdentifierClaimRequest
implements Serializable {
    private OperationEnum operation = null;
    private ContactIdentifier identifier = null;

    public IdentifierClaimRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public IdentifierClaimRequest operation(OperationEnum operation) {
        this.operation = operation;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The operation to perform claim/release")
    @JsonProperty(value="operation")
    public OperationEnum getOperation() {
        return this.operation;
    }

    public void setOperation(OperationEnum operation) {
        this.operation = operation;
    }

    public IdentifierClaimRequest identifier(ContactIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The identifier that should be claimed/released from a contact")
    @JsonProperty(value="identifier")
    public ContactIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(ContactIdentifier identifier) {
        this.identifier = identifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentifierClaimRequest identifierClaimRequest = (IdentifierClaimRequest)o;
        return Objects.equals((Object)this.operation, (Object)identifierClaimRequest.operation) && Objects.equals(this.identifier, identifierClaimRequest.identifier);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operation, this.identifier});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentifierClaimRequest {\n");
        sb.append("    operation: ").append(this.toIndentedString((Object)this.operation)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=OperationEnumDeserializer.class)
    public static enum OperationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CLAIM("Claim"),
        RELEASE("Release");

        private String value;

        private OperationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OperationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OperationEnum value : OperationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OperationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OperationEnumDeserializer
    extends StdDeserializer<OperationEnum> {
        public OperationEnumDeserializer() {
            super(OperationEnumDeserializer.class);
        }

        public OperationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OperationEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

