/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Creating an exported script via Download Service")
public class ExportScriptRequest
implements Serializable {
    private String fileName = null;
    private String versionId = null;

    public ExportScriptRequest() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ExportScriptRequest fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @ApiModelProperty(example="null", value="The final file name (no extension) of the script download: <fileName>.script")
    @JsonProperty(value="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public ExportScriptRequest versionId(String versionId) {
        this.versionId = versionId;
        return this;
    }

    @ApiModelProperty(example="null", value="The UUID version of the script to be exported.  Defaults to the current editable version.")
    @JsonProperty(value="versionId")
    public String getVersionId() {
        return this.versionId;
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExportScriptRequest exportScriptRequest = (ExportScriptRequest)o;
        return Objects.equals(this.fileName, exportScriptRequest.fileName) && Objects.equals(this.versionId, exportScriptRequest.versionId);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.versionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExportScriptRequest {\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    versionId: ").append(this.toIndentedString(this.versionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

