/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.ConversationContentListPickerSection;
import com.mypurecloud.sdk.v2.model.ConversationContentReceivedReplyMessage;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="List Picker object for presenting multiple sections of selectable items.")
public class ConversationContentListPicker
implements Serializable {
    private String id = null;
    private List<ConversationContentListPickerSection> sections = null;
    private ConversationContentReceivedReplyMessage replyMessage = null;
    private ConversationContentReceivedReplyMessage receivedMessage = null;

    public ConversationContentListPicker() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.sections = new ArrayList<ConversationContentListPickerSection>();
        }
    }

    public ConversationContentListPicker id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Optional unique identifier to help map component replies to form messages where multiple ListPickers can be present.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationContentListPicker sections(List<ConversationContentListPickerSection> sections) {
        this.sections = sections;
        return this;
    }

    @ApiModelProperty(example="null", value="An array of sections in the List Picker.")
    @JsonProperty(value="sections")
    public List<ConversationContentListPickerSection> getSections() {
        return this.sections;
    }

    public void setSections(List<ConversationContentListPickerSection> sections) {
        this.sections = sections;
    }

    public ConversationContentListPicker replyMessage(ConversationContentReceivedReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The reply message after the user has selected the options from the List Picker.")
    @JsonProperty(value="replyMessage")
    public ConversationContentReceivedReplyMessage getReplyMessage() {
        return this.replyMessage;
    }

    public void setReplyMessage(ConversationContentReceivedReplyMessage replyMessage) {
        this.replyMessage = replyMessage;
    }

    public ConversationContentListPicker receivedMessage(ConversationContentReceivedReplyMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
        return this;
    }

    @ApiModelProperty(example="null", value="The message prompt to select options in the List Picker sections.")
    @JsonProperty(value="receivedMessage")
    public ConversationContentReceivedReplyMessage getReceivedMessage() {
        return this.receivedMessage;
    }

    public void setReceivedMessage(ConversationContentReceivedReplyMessage receivedMessage) {
        this.receivedMessage = receivedMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentListPicker conversationContentListPicker = (ConversationContentListPicker)o;
        return Objects.equals(this.id, conversationContentListPicker.id) && Objects.equals(this.sections, conversationContentListPicker.sections) && Objects.equals(this.replyMessage, conversationContentListPicker.replyMessage) && Objects.equals(this.receivedMessage, conversationContentListPicker.receivedMessage);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sections, this.replyMessage, this.receivedMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentListPicker {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    sections: ").append(this.toIndentedString(this.sections)).append("\n");
        sb.append("    replyMessage: ").append(this.toIndentedString(this.replyMessage)).append("\n");
        sb.append("    receivedMessage: ").append(this.toIndentedString(this.receivedMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

