/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Single or multiline text input component.")
public class ConversationContentInput
implements Serializable {
    private String id = null;
    private String title = null;
    private String subtitle = null;
    private String placeholderText = null;
    private Boolean isRequired = null;
    private Boolean isMultipleLine = null;

    public ConversationContentInput() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public ConversationContentInput id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique identifier for the input")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ConversationContentInput title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="The main text displayed for the input field(s).")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ConversationContentInput subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional text providing more details about the input field(s).")
    @JsonProperty(value="subtitle")
    public String getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public ConversationContentInput placeholderText(String placeholderText) {
        this.placeholderText = placeholderText;
        return this;
    }

    @ApiModelProperty(example="null", value="Placeholder text for input field(s).")
    @JsonProperty(value="placeholderText")
    public String getPlaceholderText() {
        return this.placeholderText;
    }

    public void setPlaceholderText(String placeholderText) {
        this.placeholderText = placeholderText;
    }

    public ConversationContentInput isRequired(Boolean isRequired) {
        this.isRequired = isRequired;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the input field(s) are required to be filled in.")
    @JsonProperty(value="isRequired")
    public Boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(Boolean isRequired) {
        this.isRequired = isRequired;
    }

    public ConversationContentInput isMultipleLine(Boolean isMultipleLine) {
        this.isMultipleLine = isMultipleLine;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Whether the input should allow multiple lines of text.")
    @JsonProperty(value="isMultipleLine")
    public Boolean getIsMultipleLine() {
        return this.isMultipleLine;
    }

    public void setIsMultipleLine(Boolean isMultipleLine) {
        this.isMultipleLine = isMultipleLine;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationContentInput conversationContentInput = (ConversationContentInput)o;
        return Objects.equals(this.id, conversationContentInput.id) && Objects.equals(this.title, conversationContentInput.title) && Objects.equals(this.subtitle, conversationContentInput.subtitle) && Objects.equals(this.placeholderText, conversationContentInput.placeholderText) && Objects.equals(this.isRequired, conversationContentInput.isRequired) && Objects.equals(this.isMultipleLine, conversationContentInput.isMultipleLine);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.subtitle, this.placeholderText, this.isRequired, this.isMultipleLine);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationContentInput {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    subtitle: ").append(this.toIndentedString(this.subtitle)).append("\n");
        sb.append("    placeholderText: ").append(this.toIndentedString(this.placeholderText)).append("\n");
        sb.append("    isRequired: ").append(this.toIndentedString(this.isRequired)).append("\n");
        sb.append("    isMultipleLine: ").append(this.toIndentedString(this.isMultipleLine)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

