/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.WritableDivision;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A group of schedules that define the operating hours of an organization.")
public class ScheduleGroup
implements Serializable {
    private String id = null;
    private String name = null;
    private WritableDivision division = null;
    private String description = null;
    private Integer version = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String modifiedBy = null;
    private String createdBy = null;
    private StateEnum state = null;
    private String modifiedByApp = null;
    private String createdByApp = null;
    private String timeZone = null;
    private List<DomainEntityRef> openSchedules = null;
    private List<DomainEntityRef> closedSchedules = null;
    private List<DomainEntityRef> holidaySchedules = null;
    private String selfUri = null;

    public ScheduleGroup() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.openSchedules = new ArrayList<DomainEntityRef>();
            this.closedSchedules = new ArrayList<DomainEntityRef>();
            this.holidaySchedules = new ArrayList<DomainEntityRef>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public ScheduleGroup name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the entity.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ScheduleGroup division(WritableDivision division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division to which this entity belongs.")
    @JsonProperty(value="division")
    public WritableDivision getDivision() {
        return this.division;
    }

    public void setDivision(WritableDivision division) {
        this.division = division;
    }

    public ScheduleGroup description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The resource's description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScheduleGroup version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="The current version of the resource.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The ID of the user that last modified the resource.")
    @JsonProperty(value="modifiedBy")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @ApiModelProperty(example="null", value="The ID of the user that created the resource.")
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    @ApiModelProperty(example="null", value="Indicates if the resource is active, inactive, or deleted.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    @ApiModelProperty(example="null", value="The application that last modified the resource.")
    @JsonProperty(value="modifiedByApp")
    public String getModifiedByApp() {
        return this.modifiedByApp;
    }

    @ApiModelProperty(example="null", value="The application that created the resource.")
    @JsonProperty(value="createdByApp")
    public String getCreatedByApp() {
        return this.createdByApp;
    }

    public ScheduleGroup timeZone(String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @ApiModelProperty(example="null", value="The timezone the schedules are a part of.  This is not a schedule property to allow a schedule to be used in multiple timezones.")
    @JsonProperty(value="timeZone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public ScheduleGroup openSchedules(List<DomainEntityRef> openSchedules) {
        this.openSchedules = openSchedules;
        return this;
    }

    @ApiModelProperty(example="null", value="The schedules defining the hours an organization is open.")
    @JsonProperty(value="openSchedules")
    public List<DomainEntityRef> getOpenSchedules() {
        return this.openSchedules;
    }

    public void setOpenSchedules(List<DomainEntityRef> openSchedules) {
        this.openSchedules = openSchedules;
    }

    public ScheduleGroup closedSchedules(List<DomainEntityRef> closedSchedules) {
        this.closedSchedules = closedSchedules;
        return this;
    }

    @ApiModelProperty(example="null", value="The schedules defining the hours an organization is closed.")
    @JsonProperty(value="closedSchedules")
    public List<DomainEntityRef> getClosedSchedules() {
        return this.closedSchedules;
    }

    public void setClosedSchedules(List<DomainEntityRef> closedSchedules) {
        this.closedSchedules = closedSchedules;
    }

    public ScheduleGroup holidaySchedules(List<DomainEntityRef> holidaySchedules) {
        this.holidaySchedules = holidaySchedules;
        return this;
    }

    @ApiModelProperty(example="null", value="The schedules defining the hours an organization is closed for the holidays.")
    @JsonProperty(value="holidaySchedules")
    public List<DomainEntityRef> getHolidaySchedules() {
        return this.holidaySchedules;
    }

    public void setHolidaySchedules(List<DomainEntityRef> holidaySchedules) {
        this.holidaySchedules = holidaySchedules;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduleGroup scheduleGroup = (ScheduleGroup)o;
        return Objects.equals(this.id, scheduleGroup.id) && Objects.equals(this.name, scheduleGroup.name) && Objects.equals(this.division, scheduleGroup.division) && Objects.equals(this.description, scheduleGroup.description) && Objects.equals(this.version, scheduleGroup.version) && Objects.equals(this.dateCreated, scheduleGroup.dateCreated) && Objects.equals(this.dateModified, scheduleGroup.dateModified) && Objects.equals(this.modifiedBy, scheduleGroup.modifiedBy) && Objects.equals(this.createdBy, scheduleGroup.createdBy) && Objects.equals((Object)this.state, (Object)scheduleGroup.state) && Objects.equals(this.modifiedByApp, scheduleGroup.modifiedByApp) && Objects.equals(this.createdByApp, scheduleGroup.createdByApp) && Objects.equals(this.timeZone, scheduleGroup.timeZone) && Objects.equals(this.openSchedules, scheduleGroup.openSchedules) && Objects.equals(this.closedSchedules, scheduleGroup.closedSchedules) && Objects.equals(this.holidaySchedules, scheduleGroup.holidaySchedules) && Objects.equals(this.selfUri, scheduleGroup.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.division, this.description, this.version, this.dateCreated, this.dateModified, this.modifiedBy, this.createdBy, this.state, this.modifiedByApp, this.createdByApp, this.timeZone, this.openSchedules, this.closedSchedules, this.holidaySchedules, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduleGroup {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    modifiedByApp: ").append(this.toIndentedString(this.modifiedByApp)).append("\n");
        sb.append("    createdByApp: ").append(this.toIndentedString(this.createdByApp)).append("\n");
        sb.append("    timeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("    openSchedules: ").append(this.toIndentedString(this.openSchedules)).append("\n");
        sb.append("    closedSchedules: ").append(this.toIndentedString(this.closedSchedules)).append("\n");
        sb.append("    holidaySchedules: ").append(this.toIndentedString(this.holidaySchedules)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("active"),
        INACTIVE("inactive"),
        DELETED("deleted");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

