/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.KnowledgeDocumentResponse;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeDocumentVersion
implements Serializable {
    private String id = null;
    private Date datePublished = null;
    private KnowledgeDocumentResponse document = null;
    private String restoreFromVersionId = null;
    private Integer versionNumber = null;
    private Date dateExpires = null;
    private String selfUri = null;

    public KnowledgeDocumentVersion() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Globally unique identifier for the document version.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="Published date of document version. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="datePublished")
    public Date getDatePublished() {
        return this.datePublished;
    }

    @ApiModelProperty(example="null", value="The document which is versioned.")
    @JsonProperty(value="document")
    public KnowledgeDocumentResponse getDocument() {
        return this.document;
    }

    public KnowledgeDocumentVersion restoreFromVersionId(String restoreFromVersionId) {
        this.restoreFromVersionId = restoreFromVersionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The globally unique identifier for the document version. If the value is provided, the document is restored to the given version. If not, it publishes the draft changes as a new version of the document.")
    @JsonProperty(value="restoreFromVersionId")
    public String getRestoreFromVersionId() {
        return this.restoreFromVersionId;
    }

    public void setRestoreFromVersionId(String restoreFromVersionId) {
        this.restoreFromVersionId = restoreFromVersionId;
    }

    @ApiModelProperty(example="null", value="Version Number of the document.")
    @JsonProperty(value="versionNumber")
    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    @ApiModelProperty(example="null", value="Expiry date of document version, applicable only to the 'Archived' version of the document. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateExpires")
    public Date getDateExpires() {
        return this.dateExpires;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentVersion knowledgeDocumentVersion = (KnowledgeDocumentVersion)o;
        return Objects.equals(this.id, knowledgeDocumentVersion.id) && Objects.equals(this.datePublished, knowledgeDocumentVersion.datePublished) && Objects.equals(this.document, knowledgeDocumentVersion.document) && Objects.equals(this.restoreFromVersionId, knowledgeDocumentVersion.restoreFromVersionId) && Objects.equals(this.versionNumber, knowledgeDocumentVersion.versionNumber) && Objects.equals(this.dateExpires, knowledgeDocumentVersion.dateExpires) && Objects.equals(this.selfUri, knowledgeDocumentVersion.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.datePublished, this.document, this.restoreFromVersionId, this.versionNumber, this.dateExpires, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentVersion {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    datePublished: ").append(this.toIndentedString(this.datePublished)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    restoreFromVersionId: ").append(this.toIndentedString(this.restoreFromVersionId)).append("\n");
        sb.append("    versionNumber: ").append(this.toIndentedString(this.versionNumber)).append("\n");
        sb.append("    dateExpires: ").append(this.toIndentedString(this.dateExpires)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

