/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Action function settings.")
public class Function
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Date dateCreated = null;
    private String zipId = null;
    private String handler = null;
    private String runtime = null;
    private Integer timeoutSeconds = null;

    public Function() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    @ApiModelProperty(example="null", value="Function identifier.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="Function name. This is automatically created based on the Action Id.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public Function description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Description of the function. Limit 255 characters.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(example="null", value="Date and time function was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Zip file identifier.")
    @JsonProperty(value="zipId")
    public String getZipId() {
        return this.zipId;
    }

    public Function handler(String handler) {
        this.handler = handler;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Handler entry point into zip file to execute function. Should be path within upload function package to the invocation module without language extension, followed by a period and then exported invocation method name. e.g. 'src/index.handler'")
    @JsonProperty(value="handler")
    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler;
    }

    public Function runtime(String runtime) {
        this.runtime = runtime;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Runtime required for execution. Valid runtimes change over time as versions are deprecated. Use /api/v2/integrations/actions/functions/runtimes for current list.")
    @JsonProperty(value="runtime")
    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public Function timeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    @ApiModelProperty(example="null", value="Execution timeout to apply to function. Value is in seconds. Range allowed 1 to 15. Default value 15 seconds.")
    @JsonProperty(value="timeoutSeconds")
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Function function = (Function)o;
        return Objects.equals(this.id, function.id) && Objects.equals(this.name, function.name) && Objects.equals(this.description, function.description) && Objects.equals(this.dateCreated, function.dateCreated) && Objects.equals(this.zipId, function.zipId) && Objects.equals(this.handler, function.handler) && Objects.equals(this.runtime, function.runtime) && Objects.equals(this.timeoutSeconds, function.timeoutSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.dateCreated, this.zipId, this.handler, this.runtime, this.timeoutSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Function {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    zipId: ").append(this.toIndentedString(this.zipId)).append("\n");
        sb.append("    handler: ").append(this.toIndentedString(this.handler)).append("\n");
        sb.append("    runtime: ").append(this.toIndentedString(this.runtime)).append("\n");
        sb.append("    timeoutSeconds: ").append(this.toIndentedString(this.timeoutSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

