/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DocumentQueryPredicate
implements Serializable {
    private List<FieldsEnum> fields = null;
    private List<String> values = null;
    private TypeEnum type = null;

    public DocumentQueryPredicate() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.fields = new ArrayList<FieldsEnum>();
            this.values = new ArrayList<String>();
        }
    }

    public DocumentQueryPredicate fields(List<FieldsEnum> fields) {
        this.fields = fields;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the document fields to be matched against.")
    @JsonProperty(value="fields")
    public List<FieldsEnum> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldsEnum> fields) {
        this.fields = fields;
    }

    public DocumentQueryPredicate values(List<String> values) {
        this.values = values;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the values of the fields to be matched against.")
    @JsonProperty(value="values")
    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public DocumentQueryPredicate type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the matching criteria between the fields and values.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentQueryPredicate documentQueryPredicate = (DocumentQueryPredicate)o;
        return Objects.equals(this.fields, documentQueryPredicate.fields) && Objects.equals(this.values, documentQueryPredicate.values) && Objects.equals((Object)this.type, (Object)documentQueryPredicate.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fields, this.values, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentQueryPredicate {\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("Equals"),
        NOTEQUALS("NotEquals"),
        CONTAINS("Contains"),
        MATCHALL("MatchAll"),
        MATCHANY("MatchAny");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=FieldsEnumDeserializer.class)
    public static enum FieldsEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ALTERNATIVES("alternatives"),
        CATEGORYID("categoryId"),
        CATEGORYNAME("categoryName"),
        CONTEXTID("contextId"),
        CONTEXTNAME("contextName"),
        CONTEXTVALUEID("contextValueId"),
        CONTEXTVALUENAME("contextValueName"),
        DOCUMENTID("documentId"),
        LABELID("labelId"),
        LABELNAME("labelName"),
        TITLE("title"),
        VARIATIONID("variationId"),
        VISIBLE("visible"),
        STATE("state");

        private String value;

        private FieldsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FieldsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FieldsEnum value : FieldsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FieldsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class FieldsEnumDeserializer
    extends StdDeserializer<FieldsEnum> {
        public FieldsEnumDeserializer() {
            super(FieldsEnumDeserializer.class);
        }

        public FieldsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FieldsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

