/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AssessmentFormQuestionGroup;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AssessmentForm
implements Serializable {
    private String id = null;
    private Date dateModified = null;
    private String contextId = null;
    private String selfUri = null;
    private Boolean published = null;
    private Integer passPercent = null;
    private List<AssessmentFormQuestionGroup> questionGroups = null;

    public AssessmentForm() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.questionGroups = new ArrayList<AssessmentFormQuestionGroup>();
        }
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="null", value="Last modified date of the assessment form. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The unique Id for all versions of this assessment form")
    @JsonProperty(value="contextId")
    public String getContextId() {
        return this.contextId;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    @ApiModelProperty(example="null", value="If true, assessment form is published")
    @JsonProperty(value="published")
    public Boolean getPublished() {
        return this.published;
    }

    public AssessmentForm passPercent(Integer passPercent) {
        this.passPercent = passPercent;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The pass percent for the assessment form")
    @JsonProperty(value="passPercent")
    public Integer getPassPercent() {
        return this.passPercent;
    }

    public void setPassPercent(Integer passPercent) {
        this.passPercent = passPercent;
    }

    public AssessmentForm questionGroups(List<AssessmentFormQuestionGroup> questionGroups) {
        this.questionGroups = questionGroups;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A list of question groups")
    @JsonProperty(value="questionGroups")
    public List<AssessmentFormQuestionGroup> getQuestionGroups() {
        return this.questionGroups;
    }

    public void setQuestionGroups(List<AssessmentFormQuestionGroup> questionGroups) {
        this.questionGroups = questionGroups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssessmentForm assessmentForm = (AssessmentForm)o;
        return Objects.equals(this.id, assessmentForm.id) && Objects.equals(this.dateModified, assessmentForm.dateModified) && Objects.equals(this.contextId, assessmentForm.contextId) && Objects.equals(this.selfUri, assessmentForm.selfUri) && Objects.equals(this.published, assessmentForm.published) && Objects.equals(this.passPercent, assessmentForm.passPercent) && Objects.equals(this.questionGroups, assessmentForm.questionGroups);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.dateModified, this.contextId, this.selfUri, this.published, this.passPercent, this.questionGroups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssessmentForm {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    contextId: ").append(this.toIndentedString(this.contextId)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("    published: ").append(this.toIndentedString(this.published)).append("\n");
        sb.append("    passPercent: ").append(this.toIndentedString(this.passPercent)).append("\n");
        sb.append("    questionGroups: ").append(this.toIndentedString(this.questionGroups)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

