/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetBillingContractRequest {
    private String contractId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getContractId() {
        return this.contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public GetBillingContractRequest withContractId(String contractId) {
        this.setContractId(contractId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetBillingContractRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.contractId == null) {
            throw new IllegalStateException("Missing the required parameter 'contractId' when building request for GetBillingContractRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/billing/contracts/{contractId}").withPathParameter("contractId", this.contractId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String contractId) {
        return new Builder().withRequiredParams(contractId);
    }

    public static class Builder {
        private final GetBillingContractRequest request = new GetBillingContractRequest();

        private Builder() {
        }

        public Builder withContractId(String contractId) {
            this.request.setContractId(contractId);
            return this;
        }

        public Builder withRequiredParams(String contractId) {
            this.request.setContractId(contractId);
            return this;
        }

        public GetBillingContractRequest build() {
            if (this.request.contractId == null) {
                throw new IllegalStateException("Missing the required parameter 'contractId' when building request for GetBillingContractRequest.");
            }
            return this.request;
        }
    }
}

