/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.PushIntegration;
import com.mypurecloud.sdk.v2.model.SupportedContentReference;
import com.mypurecloud.sdk.v2.model.WebDeploymentConfigurationVersionEntityRef;
import com.mypurecloud.sdk.v2.model.WebDeploymentFlowEntityRef;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Details about a Web Deployment")
public class WebDeployment
implements Serializable {
    private String id = null;
    private String name = null;
    private String description = null;
    private Boolean allowAllDomains = null;
    private List<String> allowedDomains = null;
    private SupportedContentReference supportedContent = null;
    private String snippet = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private AddressableEntityRef lastModifiedUser = null;
    private WebDeploymentFlowEntityRef flow = null;
    private StatusEnum status = null;
    private List<PushIntegration> pushIntegrations = null;
    private WebDeploymentConfigurationVersionEntityRef _configuration = null;
    private String selfUri = null;

    public WebDeployment() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.allowedDomains = new ArrayList<String>();
            this.pushIntegrations = new ArrayList<PushIntegration>();
        }
    }

    @ApiModelProperty(example="null", value="The deployment ID")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WebDeployment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The deployment name")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebDeployment description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="The description of the config")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WebDeployment allowAllDomains(Boolean allowAllDomains) {
        this.allowAllDomains = allowAllDomains;
        return this;
    }

    @ApiModelProperty(example="null", value="Property indicates whether all domains are allowed or not. allowedDomains must be empty when this is set as true.")
    @JsonProperty(value="allowAllDomains")
    public Boolean getAllowAllDomains() {
        return this.allowAllDomains;
    }

    public void setAllowAllDomains(Boolean allowAllDomains) {
        this.allowAllDomains = allowAllDomains;
    }

    public WebDeployment allowedDomains(List<String> allowedDomains) {
        this.allowedDomains = allowedDomains;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of domains that are approved to use this deployment; the list will be added to CORS headers for ease of web use.")
    @JsonProperty(value="allowedDomains")
    public List<String> getAllowedDomains() {
        return this.allowedDomains;
    }

    public void setAllowedDomains(List<String> allowedDomains) {
        this.allowedDomains = allowedDomains;
    }

    public WebDeployment supportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
        return this;
    }

    @ApiModelProperty(example="null", value="The supported content profile for a deployment")
    @JsonProperty(value="supportedContent")
    public SupportedContentReference getSupportedContent() {
        return this.supportedContent;
    }

    public void setSupportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
    }

    @ApiModelProperty(example="null", value="Javascript snippet used to load the config")
    @JsonProperty(value="snippet")
    public String getSnippet() {
        return this.snippet;
    }

    @ApiModelProperty(example="null", value="The date the deployment was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="The date the deployment was most recently modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="A reference to the user who most recently modified the deployment")
    @JsonProperty(value="lastModifiedUser")
    public AddressableEntityRef getLastModifiedUser() {
        return this.lastModifiedUser;
    }

    public WebDeployment flow(WebDeploymentFlowEntityRef flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", value="A reference to the inboundshortmessage flow used by this deployment")
    @JsonProperty(value="flow")
    public WebDeploymentFlowEntityRef getFlow() {
        return this.flow;
    }

    public void setFlow(WebDeploymentFlowEntityRef flow) {
        this.flow = flow;
    }

    public WebDeployment status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The current status of the deployment")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public WebDeployment pushIntegrations(List<PushIntegration> pushIntegrations) {
        this.pushIntegrations = pushIntegrations;
        return this;
    }

    @ApiModelProperty(example="null", value="The push integration objects associated with the deployment")
    @JsonProperty(value="pushIntegrations")
    public List<PushIntegration> getPushIntegrations() {
        return this.pushIntegrations;
    }

    public void setPushIntegrations(List<PushIntegration> pushIntegrations) {
        this.pushIntegrations = pushIntegrations;
    }

    public WebDeployment _configuration(WebDeploymentConfigurationVersionEntityRef _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The config version this deployment uses")
    @JsonProperty(value="configuration")
    public WebDeploymentConfigurationVersionEntityRef getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(WebDeploymentConfigurationVersionEntityRef _configuration) {
        this._configuration = _configuration;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebDeployment webDeployment = (WebDeployment)o;
        return Objects.equals(this.id, webDeployment.id) && Objects.equals(this.name, webDeployment.name) && Objects.equals(this.description, webDeployment.description) && Objects.equals(this.allowAllDomains, webDeployment.allowAllDomains) && Objects.equals(this.allowedDomains, webDeployment.allowedDomains) && Objects.equals(this.supportedContent, webDeployment.supportedContent) && Objects.equals(this.snippet, webDeployment.snippet) && Objects.equals(this.dateCreated, webDeployment.dateCreated) && Objects.equals(this.dateModified, webDeployment.dateModified) && Objects.equals(this.lastModifiedUser, webDeployment.lastModifiedUser) && Objects.equals(this.flow, webDeployment.flow) && Objects.equals((Object)this.status, (Object)webDeployment.status) && Objects.equals(this.pushIntegrations, webDeployment.pushIntegrations) && Objects.equals(this._configuration, webDeployment._configuration) && Objects.equals(this.selfUri, webDeployment.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.allowAllDomains, this.allowedDomains, this.supportedContent, this.snippet, this.dateCreated, this.dateModified, this.lastModifiedUser, this.flow, this.status, this.pushIntegrations, this._configuration, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebDeployment {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    allowAllDomains: ").append(this.toIndentedString(this.allowAllDomains)).append("\n");
        sb.append("    allowedDomains: ").append(this.toIndentedString(this.allowedDomains)).append("\n");
        sb.append("    supportedContent: ").append(this.toIndentedString(this.supportedContent)).append("\n");
        sb.append("    snippet: ").append(this.toIndentedString(this.snippet)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    lastModifiedUser: ").append(this.toIndentedString(this.lastModifiedUser)).append("\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    pushIntegrations: ").append(this.toIndentedString(this.pushIntegrations)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        PENDING("Pending"),
        ACTIVE("Active"),
        INACTIVE("Inactive"),
        ERROR("Error"),
        DELETING("Deleting");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

