/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class LineStatus
implements Serializable {
    private String id = null;
    private Boolean reachable = null;
    private String addressOfRecord = null;
    private List<String> contactAddresses = null;
    private Date reachableStateTime = null;

    public LineStatus() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.contactAddresses = new ArrayList<String>();
        }
    }

    public LineStatus id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of this line")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LineStatus reachable(Boolean reachable) {
        this.reachable = reachable;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the edge can reach the line.")
    @JsonProperty(value="reachable")
    public Boolean getReachable() {
        return this.reachable;
    }

    public void setReachable(Boolean reachable) {
        this.reachable = reachable;
    }

    public LineStatus addressOfRecord(String addressOfRecord) {
        this.addressOfRecord = addressOfRecord;
        return this;
    }

    @ApiModelProperty(example="null", value="The line's address of record.")
    @JsonProperty(value="addressOfRecord")
    public String getAddressOfRecord() {
        return this.addressOfRecord;
    }

    public void setAddressOfRecord(String addressOfRecord) {
        this.addressOfRecord = addressOfRecord;
    }

    public LineStatus contactAddresses(List<String> contactAddresses) {
        this.contactAddresses = contactAddresses;
        return this;
    }

    @ApiModelProperty(example="null", value="The addresses used to contact the line.")
    @JsonProperty(value="contactAddresses")
    public List<String> getContactAddresses() {
        return this.contactAddresses;
    }

    public void setContactAddresses(List<String> contactAddresses) {
        this.contactAddresses = contactAddresses;
    }

    public LineStatus reachableStateTime(Date reachableStateTime) {
        this.reachableStateTime = reachableStateTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time the line entered its current reachable state. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="reachableStateTime")
    public Date getReachableStateTime() {
        return this.reachableStateTime;
    }

    public void setReachableStateTime(Date reachableStateTime) {
        this.reachableStateTime = reachableStateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineStatus lineStatus = (LineStatus)o;
        return Objects.equals(this.id, lineStatus.id) && Objects.equals(this.reachable, lineStatus.reachable) && Objects.equals(this.addressOfRecord, lineStatus.addressOfRecord) && Objects.equals(this.contactAddresses, lineStatus.contactAddresses) && Objects.equals(this.reachableStateTime, lineStatus.reachableStateTime);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.reachable, this.addressOfRecord, this.contactAddresses, this.reachableStateTime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LineStatus {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    reachable: ").append(this.toIndentedString(this.reachable)).append("\n");
        sb.append("    addressOfRecord: ").append(this.toIndentedString(this.addressOfRecord)).append("\n");
        sb.append("    contactAddresses: ").append(this.toIndentedString(this.contactAddresses)).append("\n");
        sb.append("    reachableStateTime: ").append(this.toIndentedString(this.reachableStateTime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

