/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.CampaignRuleParameters;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class CampaignRuleCondition
implements Serializable {
    private String id = null;
    private CampaignRuleParameters parameters = null;
    private ConditionTypeEnum conditionType = null;

    public CampaignRuleCondition() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            // empty if block
        }
    }

    public CampaignRuleCondition id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CampaignRuleCondition parameters(CampaignRuleParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The parameters for the CampaignRuleCondition.")
    @JsonProperty(value="parameters")
    public CampaignRuleParameters getParameters() {
        return this.parameters;
    }

    public void setParameters(CampaignRuleParameters parameters) {
        this.parameters = parameters;
    }

    public CampaignRuleCondition conditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The type of condition to evaluate.")
    @JsonProperty(value="conditionType")
    public ConditionTypeEnum getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CampaignRuleCondition campaignRuleCondition = (CampaignRuleCondition)o;
        return Objects.equals(this.id, campaignRuleCondition.id) && Objects.equals(this.parameters, campaignRuleCondition.parameters) && Objects.equals((Object)this.conditionType, (Object)campaignRuleCondition.conditionType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.parameters, this.conditionType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CampaignRuleCondition {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    conditionType: ").append(this.toIndentedString((Object)this.conditionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ConditionTypeEnumDeserializer.class)
    public static enum ConditionTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CAMPAIGNPROGRESS("campaignProgress"),
        CAMPAIGNAGENTS("campaignAgents"),
        CAMPAIGNRECORDSATTEMPTED("campaignRecordsAttempted"),
        CAMPAIGNCONTACTSMESSAGED("campaignContactsMessaged"),
        CAMPAIGNBUSINESSSUCCESS("campaignBusinessSuccess"),
        CAMPAIGNBUSINESSFAILURE("campaignBusinessFailure"),
        CAMPAIGNBUSINESSNEUTRAL("campaignBusinessNeutral"),
        CAMPAIGNVALIDATTEMPTS("campaignValidAttempts"),
        CAMPAIGNRIGHTPARTYCONTACTS("campaignRightPartyContacts");

        private String value;

        private ConditionTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ConditionTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ConditionTypeEnum value : ConditionTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ConditionTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ConditionTypeEnumDeserializer
    extends StdDeserializer<ConditionTypeEnum> {
        public ConditionTypeEnumDeserializer() {
            super(ConditionTypeEnumDeserializer.class);
        }

        public ConditionTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ConditionTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

