/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class HeadNotificationsChannelRequest {
    private String channelId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getChannelId() {
        return this.channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public HeadNotificationsChannelRequest withChannelId(String channelId) {
        this.setChannelId(channelId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public HeadNotificationsChannelRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.channelId == null) {
            throw new IllegalStateException("Missing the required parameter 'channelId' when building request for HeadNotificationsChannelRequest.");
        }
        return ApiRequestBuilder.create("HEAD", "/api/v2/notifications/channels/{channelId}").withPathParameter("channelId", this.channelId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String channelId) {
        return new Builder().withRequiredParams(channelId);
    }

    public static class Builder {
        private final HeadNotificationsChannelRequest request = new HeadNotificationsChannelRequest();

        private Builder() {
        }

        public Builder withChannelId(String channelId) {
            this.request.setChannelId(channelId);
            return this;
        }

        public Builder withRequiredParams(String channelId) {
            this.request.setChannelId(channelId);
            return this;
        }

        public HeadNotificationsChannelRequest build() {
            if (this.request.channelId == null) {
                throw new IllegalStateException("Missing the required parameter 'channelId' when building request for HeadNotificationsChannelRequest.");
            }
            return this.request;
        }
    }
}

