/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.SuggestionKnowledgeAnswer;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SuggestionKnowledgeSearch
implements Serializable {
    private String title = null;
    private List<String> snippets = null;
    private Float confidence = null;
    private String searchId = null;
    private AddressableEntityRef document = null;
    private AddressableEntityRef version = null;
    private SuggestionKnowledgeAnswer knowledgeAnswer = null;
    private List<AddressableEntityRef> variations = null;

    public SuggestionKnowledgeSearch() {
        if (ApiClient.LEGACY_EMPTY_LIST.booleanValue()) {
            this.snippets = new ArrayList<String>();
            this.variations = new ArrayList<AddressableEntityRef>();
        }
    }

    @ApiModelProperty(example="null", value="The article title.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @ApiModelProperty(example="null", value="Snippets of text from the article matching the query.")
    @JsonProperty(value="snippets")
    public List<String> getSnippets() {
        return this.snippets;
    }

    @ApiModelProperty(example="null", value="Value between 0 and 1. 1 corresponds to very confident, 0 to not confident at all.")
    @JsonProperty(value="confidence")
    public Float getConfidence() {
        return this.confidence;
    }

    @ApiModelProperty(example="null", value="The search id.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    @ApiModelProperty(example="null", value="The article matching the query.")
    @JsonProperty(value="document")
    public AddressableEntityRef getDocument() {
        return this.document;
    }

    @ApiModelProperty(example="null", value="The version of the article.")
    @JsonProperty(value="version")
    public AddressableEntityRef getVersion() {
        return this.version;
    }

    @ApiModelProperty(example="null", value="The most relevant answer within a searched article for the searched query")
    @JsonProperty(value="knowledgeAnswer")
    public SuggestionKnowledgeAnswer getKnowledgeAnswer() {
        return this.knowledgeAnswer;
    }

    @ApiModelProperty(example="null", value="Variations of the article.")
    @JsonProperty(value="variations")
    public List<AddressableEntityRef> getVariations() {
        return this.variations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuggestionKnowledgeSearch suggestionKnowledgeSearch = (SuggestionKnowledgeSearch)o;
        return Objects.equals(this.title, suggestionKnowledgeSearch.title) && Objects.equals(this.snippets, suggestionKnowledgeSearch.snippets) && Objects.equals(this.confidence, suggestionKnowledgeSearch.confidence) && Objects.equals(this.searchId, suggestionKnowledgeSearch.searchId) && Objects.equals(this.document, suggestionKnowledgeSearch.document) && Objects.equals(this.version, suggestionKnowledgeSearch.version) && Objects.equals(this.knowledgeAnswer, suggestionKnowledgeSearch.knowledgeAnswer) && Objects.equals(this.variations, suggestionKnowledgeSearch.variations);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.snippets, this.confidence, this.searchId, this.document, this.version, this.knowledgeAnswer, this.variations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SuggestionKnowledgeSearch {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    snippets: ").append(this.toIndentedString(this.snippets)).append("\n");
        sb.append("    confidence: ").append(this.toIndentedString(this.confidence)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    knowledgeAnswer: ").append(this.toIndentedString(this.knowledgeAnswer)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

